/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.SeriesGroupBy;
import org.dflib.Sorter;
import org.dflib.ValueMapper;
import org.dflib.ValueToRowMapper;
import org.dflib.builder.BoolAccum;
import org.dflib.builder.BoolBuilder;
import org.dflib.builder.IntAccum;
import org.dflib.builder.ObjectAccum;
import org.dflib.concat.SeriesConcat;
import org.dflib.groupby.SeriesGrouper;
import org.dflib.map.Mapper;
import org.dflib.sample.Sampler;
import org.dflib.series.ArraySeries;
import org.dflib.series.FalseSeries;
import org.dflib.series.ToString;
import org.dflib.series.TrueSeries;
import org.dflib.series.ValueCounts;
import org.dflib.sort.SeriesSorter;

public abstract class BooleanBaseSeries
implements BooleanSeries {
    @Override
    public <S> Series<S> castAs(Class<S> type) {
        if (!type.equals(Boolean.class) && !type.equals(Boolean.TYPE)) {
            throw new ClassCastException("BooleanSeries can not be cast to " + String.valueOf(type));
        }
        return this;
    }

    @Override
    public DataFrame map(Index resultColumns, ValueToRowMapper<Boolean> mapper) {
        return Mapper.map(this, resultColumns, mapper);
    }

    @Override
    public Series<Boolean> selectRange(int fromInclusive, int toExclusive) {
        return this.rangeBool(fromInclusive, toExclusive);
    }

    @Override
    public BooleanSeries select(Predicate<Boolean> p) {
        return this.selectAsBooleanSeries(this.index(p));
    }

    @Override
    public BooleanSeries select(Condition condition) {
        return this.select((BooleanSeries)condition.eval((Series)this));
    }

    @Override
    public BooleanSeries select(BooleanSeries positions) {
        int i;
        int len = this.size();
        if (len != positions.size()) {
            throw new IllegalArgumentException("Positions size " + positions.size() + " is not the same as this size " + len);
        }
        for (i = 0; i < len && !positions.getBool(i); ++i) {
        }
        if (i == len) {
            return Series.ofBool(new boolean[0]);
        }
        BoolAccum filtered = new BoolAccum(len - i);
        filtered.pushBool(this.getBool(i));
        ++i;
        while (i < len) {
            if (positions.getBool(i)) {
                filtered.pushBool(this.getBool(i));
            }
            ++i;
        }
        return filtered.toSeries();
    }

    @Override
    public BooleanSeries sort(Sorter ... sorters) {
        return this.selectAsBooleanSeries(new SeriesSorter<Boolean>(this).sortIndex(sorters));
    }

    @Override
    public BooleanSeries sort(Comparator<? super Boolean> comparator) {
        return this.selectAsBooleanSeries(new SeriesSorter<Boolean>(this).sortIndex(comparator));
    }

    private BooleanSeries selectAsBooleanSeries(IntSeries positions) {
        return BoolBuilder.buildSeries(i -> this.getBool(positions.getInt(i)), positions.size());
    }

    @Override
    public BooleanSeries concatBool(BooleanSeries ... other) {
        int size;
        if (other.length == 0) {
            return this;
        }
        int h = size = this.size();
        for (BooleanSeries s : other) {
            h += s.size();
        }
        BoolAccum accum = new BoolAccum(h);
        accum.fill(this, 0, 0, size);
        int offset = size;
        for (BooleanSeries s : other) {
            int len = s.size();
            accum.fill(s, 0, offset, len);
            offset += len;
        }
        return accum.toSeries();
    }

    @Override
    public Series<Boolean> fillNullsFromSeries(Series<? extends Boolean> values) {
        return this;
    }

    @Override
    public Series<Boolean> fillNulls(Boolean value) {
        return this;
    }

    @Override
    public Series<Boolean> fillNullsBackwards() {
        return this;
    }

    @Override
    public Series<Boolean> fillNullsForward() {
        return this;
    }

    @Override
    @SafeVarargs
    public final Series<Boolean> concat(Series<? extends Boolean> ... other) {
        if (other.length == 0) {
            return this;
        }
        Series[] combined = new Series[other.length + 1];
        combined[0] = this;
        System.arraycopy(other, 0, combined, 1, other.length);
        return SeriesConcat.concat(combined);
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size()) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        for (int i = 0; i < len; ++i) {
            to[toOffset + i] = this.getBool(fromOffset + i);
        }
    }

    @Override
    public IntSeries indexTrue() {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (!this.getBool(i)) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public IntSeries indexFalse() {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (this.getBool(i)) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public IntSeries index(Predicate<Boolean> predicate) {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(this.get(i))) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public Series<Boolean> replace(Map<Boolean, Boolean> oldToNewValues) {
        int len = this.size();
        boolean[] replaced = new boolean[len];
        for (int i = 0; i < len; ++i) {
            Boolean val = this.getBool(i);
            Boolean newVal = oldToNewValues.getOrDefault(val, val);
            if (newVal == null) {
                return this.replaceAsObjects(oldToNewValues);
            }
            replaced[i] = newVal;
        }
        return Series.ofBool(replaced);
    }

    private Series<Boolean> replaceAsObjects(Map<Boolean, Boolean> oldToNewValues) {
        int len = this.size();
        Boolean[] replaced = new Boolean[len];
        for (int i = 0; i < len; ++i) {
            Boolean val = this.getBool(i);
            replaced[i] = oldToNewValues.getOrDefault(val, val);
        }
        return Series.of(replaced);
    }

    @Override
    public Series<Boolean> replace(IntSeries positions, Series<Boolean> with) {
        int rs = positions.size();
        if (rs != with.size()) {
            throw new IllegalArgumentException("Positions size " + rs + " is not the same replacement Series size " + with.size());
        }
        if (rs == 0) {
            return this;
        }
        int s = this.size();
        if (with instanceof BooleanSeries) {
            BooleanSeries withBool = (BooleanSeries)with;
            BoolAccum values = new BoolAccum(s);
            values.fill(this, 0, 0, s);
            for (int i = 0; i < rs; ++i) {
                values.replace(positions.getInt(i), withBool.getBool(i));
            }
            return values.toSeries();
        }
        ObjectAccum<Boolean> values = new ObjectAccum<Boolean>(s);
        values.fill(this, 0, 0, s);
        for (int i = 0; i < rs; ++i) {
            values.replace(positions.getInt(i), with.get(i));
        }
        return values.toSeries();
    }

    @Override
    public Series<Boolean> replace(BooleanSeries condition, Boolean with) {
        return with != null ? this.replaceBoolean(condition, with) : this.nullify(condition);
    }

    @Override
    public Series<Boolean> replaceExcept(BooleanSeries condition, Boolean with) {
        return with != null ? this.replaceNoMatchBoolean(condition, with) : this.nullifyNoMatch(condition);
    }

    private BooleanSeries replaceBoolean(BooleanSeries condition, boolean with) {
        int len = this.size();
        int r = Math.min(len, condition.size());
        return BoolBuilder.buildSeries(i -> i < r && condition.getBool(i) ? with : this.getBool(i), len);
    }

    private BooleanSeries replaceNoMatchBoolean(BooleanSeries condition, boolean with) {
        int len = this.size();
        int r = Math.min(len, condition.size());
        return BoolBuilder.buildSeries(i -> i < r && condition.getBool(i) ? this.getBool(i) : with, len);
    }

    private Series<Boolean> nullify(BooleanSeries condition) {
        int i;
        int len = this.size();
        int r = Math.min(len, condition.size());
        Boolean[] data = new Boolean[len];
        for (i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? null : Boolean.valueOf(this.getBool(i));
        }
        for (i = r; i < len; ++i) {
            data[i] = this.getBool(i);
        }
        return new ArraySeries<Boolean>(data);
    }

    private Series<Boolean> nullifyNoMatch(BooleanSeries condition) {
        int len = this.size();
        int r = Math.min(len, condition.size());
        Object[] data = new Boolean[len];
        for (int i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? Boolean.valueOf(this.getBool(i)) : null;
        }
        if (len > r) {
            Arrays.fill(data, r, len, null);
        }
        return new ArraySeries<Boolean>(data);
    }

    @Override
    public BooleanSeries in(Object ... values) {
        int len = this.size();
        if (values == null || values.length == 0) {
            return new FalseSeries(len);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : values) {
            if (!(o instanceof Boolean)) continue;
            set.add(o);
        }
        if (set.isEmpty()) {
            return new FalseSeries(len);
        }
        return BoolBuilder.buildSeries(i -> set.contains(this.get(i)), len);
    }

    @Override
    public BooleanSeries notIn(Object ... values) {
        int len = this.size();
        if (values == null || values.length == 0) {
            return new TrueSeries(len);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : values) {
            if (!(o instanceof Boolean)) continue;
            set.add(o);
        }
        if (set.isEmpty()) {
            return new TrueSeries(len);
        }
        return BoolBuilder.buildSeries(i -> !set.contains(this.get(i)), len);
    }

    @Override
    public boolean isTrue() {
        return this.size() > 0 && this.firstFalse() == -1;
    }

    @Override
    public boolean isFalse() {
        return this.size() > 0 && this.firstTrue() == -1;
    }

    @Override
    public BooleanSeries unique() {
        int size = this.size();
        if (size < 2) {
            return this;
        }
        int iTrue = -1;
        int iFalse = -1;
        for (int i = 0; i < size && (iTrue < 0 || iFalse < 0); ++i) {
            if (this.get(i).booleanValue()) {
                iTrue = i;
                continue;
            }
            iFalse = i;
        }
        if (iTrue < 0) {
            return iFalse < 0 ? Series.ofBool(new boolean[0]) : Series.ofBool(false);
        }
        return iFalse < 0 ? Series.ofBool(true) : (iTrue < iFalse ? Series.ofBool(true, false) : Series.ofBool(false, true));
    }

    @Override
    public BooleanSeries and(BooleanSeries another) {
        return BooleanSeries.andAll(this, another);
    }

    @Override
    public BooleanSeries or(BooleanSeries another) {
        return BooleanSeries.orAll(this, another);
    }

    @Override
    public BooleanSeries not() {
        int size = this.size();
        if (size == 0) {
            return this;
        }
        return BoolBuilder.buildSeries(i -> !this.getBool(i), size);
    }

    @Override
    public DataFrame valueCounts() {
        return ValueCounts.valueCountsNoNulls(this);
    }

    @Override
    public SeriesGroupBy<Boolean> group() {
        return this.group((Boolean i) -> i);
    }

    @Override
    public SeriesGroupBy<Boolean> group(ValueMapper<Boolean, ?> by) {
        return new SeriesGrouper<Boolean>(by).group(this);
    }

    @Override
    public BooleanSeries sample(int size) {
        return this.selectAsBooleanSeries(Sampler.sampleIndex(size, this.size()));
    }

    @Override
    public BooleanSeries sample(int size, Random random) {
        return this.selectAsBooleanSeries(Sampler.sampleIndex(size, this.size(), random));
    }

    public String toString() {
        return ToString.toString(this);
    }
}

