/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.BooleanSeries;
import org.dflib.IntSeries;
import org.dflib.agg.PrimitiveSeriesCount;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.series.BooleanArraySeries;
import org.dflib.series.BooleanBaseSeries;
import org.dflib.series.IntArraySeries;

@Deprecated(since="2.0.0", forRemoval=true)
public class BooleanArrayRangeSeries
extends BooleanBaseSeries {
    private final boolean[] data;
    private final int offset;
    private final int size;

    public BooleanArrayRangeSeries(boolean[] data, int offset, int size) {
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean getBool(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[this.offset + index];
    }

    @Override
    public void copyToBool(boolean[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        System.arraycopy(this.data, this.offset + fromOffset, to, toOffset, len);
    }

    @Override
    public BooleanSeries rangeBool(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new BooleanArrayRangeSeries(this.data, this.offset + fromInclusive, toExclusive - fromInclusive);
    }

    @Override
    public BooleanSeries materialize() {
        if (this.offset == 0 && this.size == this.data.length) {
            return new BooleanArraySeries(this.data);
        }
        boolean[] data = new boolean[this.size];
        this.copyToBool(data, 0, 0, this.size);
        return new BooleanArraySeries(data);
    }

    @Override
    public int firstTrue() {
        for (int i = 0; i < this.size; ++i) {
            if (!this.data[this.offset + i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int firstFalse() {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[this.offset + i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int countTrue() {
        return PrimitiveSeriesCount.countTrueInArray(this.data, this.offset, this.size);
    }

    @Override
    public int countFalse() {
        return PrimitiveSeriesCount.countFalseInArray(this.data, this.offset, this.size);
    }

    @Override
    public IntSeries cumSum() {
        int[] cumSum = PrimitiveSeriesSum.cumSumOfArray(this.data, this.offset, this.size);
        return new IntArraySeries(cumSum);
    }
}

