/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import org.dflib.Series;
import org.dflib.series.ArraySeries;
import org.dflib.series.ObjectSeries;

public class ArrayRangeSeries<T>
extends ObjectSeries<T> {
    private final T[] data;
    private final int offset;
    private final int size;

    public ArrayRangeSeries(Class<?> nominalType, T[] data, int offset, int size) {
        super(nominalType);
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[this.offset + index];
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        System.arraycopy(this.data, this.offset + fromOffset, to, toOffset, len);
    }

    @Override
    public Series<T> materialize() {
        if (this.offset == 0 && this.size == this.data.length) {
            return new ArraySeries<T>(this.data);
        }
        Object[] data = new Object[this.size];
        this.copyTo(data, 0, 0, this.size);
        return new ArraySeries<Object>(data);
    }

    @Override
    public Series<T> fillNulls(T value) {
        Object[] copy = null;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[this.offset + i] != null) continue;
            if (copy == null) {
                copy = new Object[this.size];
                System.arraycopy(this.data, this.offset, copy, 0, this.size);
            }
            copy[i] = value;
        }
        return copy != null ? new ArraySeries(copy) : this;
    }

    @Override
    public Series<T> fillNullsFromSeries(Series<? extends T> values) {
        Object[] copy = null;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[this.offset + i] != null) continue;
            if (copy == null) {
                copy = new Object[this.size];
                System.arraycopy(this.data, this.offset, copy, 0, this.size);
            }
            copy[i] = values.get(i);
        }
        return copy != null ? new ArraySeries(copy) : this;
    }

    @Override
    public Series<T> fillNullsBackwards() {
        Object[] copy = null;
        int fillFrom = -1;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[this.offset + i] == null) {
                if (copy == null) {
                    copy = new Object[this.size];
                    System.arraycopy(this.data, this.offset, copy, 0, this.size);
                }
                if (fillFrom >= 0) continue;
                fillFrom = i;
                continue;
            }
            if (fillFrom < 0) continue;
            Arrays.fill(copy, fillFrom, i, this.data[this.offset + i]);
            fillFrom = -1;
        }
        return copy != null ? new ArraySeries(copy) : this;
    }

    @Override
    public Series<T> fillNullsForward() {
        Object[] copy = null;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[this.offset + i] != null || i == 0) continue;
            if (copy == null) {
                copy = new Object[this.size];
                System.arraycopy(this.data, this.offset, copy, 0, this.size);
            }
            copy[i] = copy[i - 1];
        }
        return copy != null ? new ArraySeries(copy) : this;
    }

    @Override
    public Series<T> selectRange(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new ArrayRangeSeries<T>(this.getNominalType(), this.data, this.offset + fromInclusive, toExclusive - fromInclusive);
    }
}

