/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.sample;

import java.security.SecureRandom;
import java.util.Random;
import org.dflib.IntSeries;
import org.dflib.Series;

public class Sampler {
    private static final Random defaultRandom = new SecureRandom();

    public static Random getDefaultRandom() {
        return defaultRandom;
    }

    public static IntSeries sampleIndex(int sampleSize, int originalSize) {
        return Sampler.sampleIndex(sampleSize, originalSize, defaultRandom);
    }

    public static IntSeries sampleIndex(int sampleSize, int originalSize, Random random) {
        if (sampleSize > originalSize) {
            throw new IllegalArgumentException("Sample size must not be higher than the original size");
        }
        int[] data = Sampler.intSequence(originalSize);
        Sampler.shuffle(data, random);
        return Series.ofInt(data).head(sampleSize);
    }

    private static int[] intSequence(int size) {
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            data[i] = i;
        }
        return data;
    }

    private static void shuffle(int[] ints, Random random) {
        int size;
        for (int i = size = ints.length; i > 1; --i) {
            Sampler.swap(ints, i - 1, random.nextInt(i));
        }
    }

    private static void swap(int[] ints, int i, int j) {
        int tmp = ints[i];
        ints[i] = ints[j];
        ints[j] = tmp;
    }
}

