/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.row;

import org.dflib.Index;
import org.dflib.Series;
import org.dflib.row.RowBuilder;
import org.dflib.row.RowProxy;

public class ColumnsRowProxy
implements RowProxy {
    private final Index columns;
    private final Series[] data;
    private final int height;
    private int rowIndex;

    public ColumnsRowProxy(Index columns, Series[] data, int height) {
        this.columns = columns;
        this.data = data;
        this.height = height;
        this.rowIndex = -1;
    }

    public boolean hasNext() {
        return this.rowIndex + 1 < this.height;
    }

    public ColumnsRowProxy next() {
        ++this.rowIndex;
        return this;
    }

    public ColumnsRowProxy next(int index) {
        this.rowIndex = index;
        return this;
    }

    @Override
    public Index getIndex() {
        return this.columns;
    }

    @Override
    public Object get(int columnPos) {
        return this.data[columnPos].get(this.rowIndex);
    }

    @Override
    public Object get(String columnName) {
        return this.data[this.columns.position(columnName)].get(this.rowIndex);
    }

    @Override
    public int getInt(int columnPos) {
        return this.data[columnPos].castAsInt().getInt(this.rowIndex);
    }

    @Override
    public int getInt(String columnName) {
        return this.getInt(this.columns.position(columnName));
    }

    @Override
    public long getLong(int columnPos) {
        return this.data[columnPos].castAsLong().getLong(this.rowIndex);
    }

    @Override
    public long getLong(String columnName) {
        return this.getLong(this.columns.position(columnName));
    }

    @Override
    public double getDouble(int columnPos) {
        return this.data[columnPos].castAsDouble().getDouble(this.rowIndex);
    }

    @Override
    public double getDouble(String columnName) {
        return this.getDouble(this.columns.position(columnName));
    }

    @Override
    public boolean getBool(int columnPos) {
        return this.data[columnPos].castAsBool().getBool(this.rowIndex);
    }

    @Override
    public boolean getBool(String columnName) {
        return this.getBool(this.columns.position(columnName));
    }

    @Override
    public void copyRange(RowBuilder to, int fromOffset, int toOffset, int len) {
        if (this.rowIndex >= 0) {
            int w = this.data.length;
            for (int i = 0; i < w; ++i) {
                to.set(i + toOffset, this.data[i].get(this.rowIndex));
            }
        }
    }
}

