/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.print;

import org.dflib.Series;
import org.dflib.series.EmptySeries;

public class SeriesTruncator<T> {
    Series<T> series;
    boolean truncated;
    int head;
    int tail;

    private SeriesTruncator(Series<T> series, boolean truncated, int head, int tail) {
        this.series = series;
        this.truncated = truncated;
        this.head = head;
        this.tail = tail;
    }

    public static <T> SeriesTruncator<T> create(Series<T> series, int maxSize) {
        int h;
        if (maxSize < 0) {
            maxSize = 0;
        }
        if ((h = series.size()) <= maxSize) {
            return new SeriesTruncator<T>(series, false, h, 0);
        }
        int head = maxSize / 2 + maxSize % 2;
        int tail = maxSize - head;
        return new SeriesTruncator<T>(series, true, head, tail);
    }

    public Series<T> head() {
        return this.truncated ? this.series.head(this.head) : this.series;
    }

    public Series<T> tail() {
        return this.truncated ? this.series.tail(this.tail) : new EmptySeries();
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public int size() {
        return this.truncated ? this.head + this.tail + 1 : this.series.size();
    }
}

