/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.print;

import org.dflib.Series;
import org.dflib.print.BasePrintWorker;
import org.dflib.print.SeriesTruncator;

public class SeriesTabularPrintWorker
extends BasePrintWorker {
    public SeriesTabularPrintWorker(StringBuilder out, int maxDisplayRows, int maxDisplayColumnWidth) {
        super(out, maxDisplayRows, maxDisplayColumnWidth);
    }

    public StringBuilder print(Series<?> s) {
        int i;
        if (s == null) {
            this.out.append("null");
            return this.out;
        }
        int h = s.size();
        if (h == 0) {
            this.appendNewLine().append("0 elements");
            return this.out;
        }
        int columnWidth = 0;
        SeriesTruncator<?> truncator = SeriesTruncator.create(s, this.maxDisplayRows);
        String[] values = new String[truncator.size()];
        Series<?> head = truncator.head();
        int hs = head.size();
        for (i = 0; i < hs; ++i) {
            values[i] = String.valueOf(head.get(i));
            columnWidth = Math.max(columnWidth, values[i].length());
        }
        if (truncator.isTruncated()) {
            values[hs] = "...";
            Series<?> tail = truncator.tail();
            int ts = tail.size();
            for (int i2 = 0; i2 < ts; ++i2) {
                String val;
                values[hs + 1 + i2] = val = String.valueOf(tail.get(i2));
                columnWidth = Math.max(columnWidth, val.length());
            }
        }
        columnWidth = Math.max(1, Math.min(columnWidth, this.maxDisplayColumnWidth));
        String columnFormat = this.columnFormat(columnWidth, s.getInferredType());
        this.appendNewLine();
        for (i = 0; i < values.length; ++i) {
            if (i > 0) {
                this.appendNewLine();
            }
            this.appendFixedWidth(values[i], columnWidth, columnFormat);
        }
        String rowsLabel = h == 1 ? " element" : " elements";
        this.appendNewLine().append(h).append(rowsLabel);
        return this.out;
    }
}

