/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.print;

import org.dflib.DataFrame;

public class DataFrameTruncator {
    DataFrame dataFrame;
    boolean truncated;
    int head;
    int tail;

    private DataFrameTruncator(DataFrame dataFrame, boolean truncated, int head, int tail) {
        this.dataFrame = dataFrame;
        this.truncated = truncated;
        this.head = head;
        this.tail = tail;
    }

    public static DataFrameTruncator create(DataFrame dataFrame, int maxHeight) {
        int h;
        if (maxHeight < 0) {
            maxHeight = 0;
        }
        if ((h = dataFrame.height()) <= maxHeight) {
            return new DataFrameTruncator(dataFrame, false, h, 0);
        }
        int head = maxHeight / 2 + maxHeight % 2;
        int tail = maxHeight - head;
        return new DataFrameTruncator(dataFrame, true, head, tail);
    }

    public DataFrame head() {
        return this.truncated ? this.dataFrame.head(this.head) : this.dataFrame;
    }

    public DataFrame tail() {
        return this.truncated ? this.dataFrame.tail(this.tail) : DataFrame.empty(this.dataFrame.getColumnsIndex());
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public int height() {
        return this.truncated ? this.head + this.tail + 1 : this.dataFrame.height();
    }
}

