/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.print;

import java.util.ArrayList;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.print.BasePrintWorker;
import org.dflib.print.DataFrameTruncator;
import org.dflib.row.RowProxy;

public class DataFrameTabularPrintWorker
extends BasePrintWorker {
    public DataFrameTabularPrintWorker(StringBuilder out, int maxDisplayRows, int maxDisplayColumnWith) {
        super(out, maxDisplayRows, maxDisplayColumnWith);
    }

    public StringBuilder print(DataFrame df) {
        int i;
        if (df == null) {
            this.out.append("null");
            return this.out;
        }
        Index columns = df.getColumnsIndex();
        int w = columns.size();
        if (w == 0) {
            return this.out;
        }
        int[] columnWidth = new int[w];
        String[] columnFormat = new String[w];
        DataFrameTruncator truncator = DataFrameTruncator.create(df, this.maxDisplayRows);
        for (int i2 = 0; i2 < w; ++i2) {
            columnWidth[i2] = columns.get(i2) != null ? columns.get(i2).length() : 4;
        }
        DataFrame head = truncator.head();
        ArrayList<String[]> headData = new ArrayList<String[]>(head.height());
        for (RowProxy p : head) {
            String[] rValue = new String[w];
            for (int i3 = 0; i3 < w; ++i3) {
                rValue[i3] = String.valueOf(p.get(i3));
                columnWidth[i3] = Math.max(columnWidth[i3], ((String)rValue[i3]).length());
            }
            headData.add(rValue);
        }
        ArrayList<String[]> tailData = null;
        if (truncator.isTruncated()) {
            DataFrame tail = truncator.tail();
            tailData = new ArrayList<String[]>(tail.height());
            for (RowProxy p : tail) {
                String[] rValue = new String[w];
                for (int i4 = 0; i4 < w; ++i4) {
                    rValue[i4] = String.valueOf(p.get(i4));
                    columnWidth[i4] = Math.max(columnWidth[i4], rValue[i4].length());
                }
                tailData.add(rValue);
            }
        }
        this.appendNewLine();
        for (i = 0; i < w; ++i) {
            columnWidth[i] = Math.max(1, Math.min(columnWidth[i], this.maxDisplayColumnWidth));
            columnFormat[i] = this.columnFormat(columnWidth[i], df.getColumn(i).getInferredType());
        }
        for (i = 0; i < w; ++i) {
            if (i > 0) {
                this.append(" ");
            }
            this.appendFixedWidth(columns.get(i), columnWidth[i], columnFormat[i]);
        }
        this.appendNewLine();
        for (i = 0; i < w; ++i) {
            if (i > 0) {
                this.append(" ");
            }
            for (int j = 0; j < columnWidth[i]; ++j) {
                this.append("-");
            }
        }
        for (String[] row : headData) {
            this.appendNewLine();
            for (int i5 = 0; i5 < w; ++i5) {
                if (i5 > 0) {
                    this.append(" ");
                }
                this.appendFixedWidth(row[i5], columnWidth[i5], columnFormat[i5]);
            }
        }
        if (truncator.isTruncated()) {
            this.appendNewLine().append("...");
            for (String[] row : tailData) {
                this.appendNewLine();
                for (int i6 = 0; i6 < w; ++i6) {
                    if (i6 > 0) {
                        this.append(" ");
                    }
                    this.appendFixedWidth(row[i6], columnWidth[i6], columnFormat[i6]);
                }
            }
        }
        int h = df.height();
        String nameLabel = df.getName() != null ? "[" + df.getName() + "] " : "";
        String rowsLabel = h == 1 ? " row x " : " rows x ";
        String columnsLabel = w == 1 ? " column" : " columns";
        this.appendNewLine().append(nameLabel).append(h).append(rowsLabel).append(w).append(columnsLabel);
        return this.out;
    }

    StringBuilder append(String string) {
        return this.out.append(string);
    }
}

