/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.print;

import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.print.BasePrintWorker;
import org.dflib.print.DataFrameTruncator;
import org.dflib.row.RowProxy;

public class DataFrameInlinePrintWorker
extends BasePrintWorker {
    public DataFrameInlinePrintWorker(StringBuilder out, int maxDisplayRows, int maxDisplayColumnWith) {
        super(out, maxDisplayRows, maxDisplayColumnWith);
    }

    public StringBuilder print(DataFrame df) {
        int j;
        if (df == null) {
            this.out.append("null");
            return this.out;
        }
        DataFrameTruncator truncator = DataFrameTruncator.create(df, this.maxDisplayRows);
        Index columns = df.getColumnsIndex();
        int width = columns.size();
        int h = truncator.height();
        if (h == 0) {
            for (int j2 = 0; j2 < width; ++j2) {
                if (j2 > 0) {
                    this.out.append(",");
                }
                this.appendTruncate(columns.get(j2));
                this.out.append(":");
            }
            return this.out;
        }
        boolean comma = false;
        for (RowProxy p : truncator.head()) {
            if (comma) {
                this.out.append(",");
            }
            comma = true;
            this.out.append("{");
            for (j = 0; j < width; ++j) {
                if (j > 0) {
                    this.out.append(",");
                }
                this.appendTruncate(columns.get(j));
                this.out.append(":");
                this.appendTruncate(String.valueOf(p.get(j)));
            }
            this.out.append("}");
        }
        if (truncator.isTruncated()) {
            if (comma) {
                this.out.append(",");
            }
            this.out.append("...");
            for (RowProxy p : truncator.tail()) {
                this.out.append(",{");
                for (j = 0; j < width; ++j) {
                    if (j > 0) {
                        this.out.append(",");
                    }
                    this.appendTruncate(columns.get(j));
                    this.out.append(":");
                    this.appendTruncate(String.valueOf(p.get(j)));
                }
                this.out.append("}");
            }
        }
        return this.out;
    }
}

