/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.join;

import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.IntSeries;
import org.dflib.JoinType;

public abstract class BaseJoiner {
    private final JoinType semantics;

    public BaseJoiner(JoinType semantics) {
        this.semantics = Objects.requireNonNull(semantics);
    }

    public IntSeries[] rowSelectors(DataFrame lf, DataFrame rf) {
        switch (this.semantics) {
            case inner: {
                return this.innerJoin(lf, rf);
            }
            case left: {
                return this.leftJoin(lf, rf);
            }
            case right: {
                return this.rightJoin(lf, rf);
            }
            case full: {
                return this.fullJoin(lf, rf);
            }
        }
        throw new IllegalStateException("Unsupported join semantics: " + String.valueOf((Object)this.semantics));
    }

    protected abstract IntSeries[] innerJoin(DataFrame var1, DataFrame var2);

    protected abstract IntSeries[] leftJoin(DataFrame var1, DataFrame var2);

    protected abstract IntSeries[] rightJoin(DataFrame var1, DataFrame var2);

    protected abstract IntSeries[] fullJoin(DataFrame var1, DataFrame var2);
}

