/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.index;

import java.util.HashSet;
import java.util.Set;
import org.dflib.Index;

public abstract class StringDeduplicator {
    public static StringDeduplicator of(int capacity) {
        return new DefaultDeduplicator(capacity);
    }

    public static StringDeduplicator of(Index index, int capacity) {
        return new RefIndexDeduplicator(index, capacity);
    }

    public abstract String nonConflictingName(String var1);

    public String[] nonConflicting(String[] values) {
        int i;
        int len = values.length;
        String firstConflict = null;
        for (i = 0; i < len; ++i) {
            String l = this.nonConflictingName(values[i]);
            if (l == values[i]) continue;
            firstConflict = l;
            break;
        }
        if (firstConflict == null) {
            return values;
        }
        String[] nonConflicting = new String[len];
        System.arraycopy(values, 0, nonConflicting, 0, i);
        nonConflicting[i] = firstConflict;
        for (int j = i + 1; j < len; ++j) {
            nonConflicting[j] = this.nonConflictingName(values[j]);
        }
        return nonConflicting != null ? nonConflicting : values;
    }

    public static class DefaultDeduplicator
    extends StringDeduplicator {
        private final Set<String> seen;

        DefaultDeduplicator(int capacity) {
            this.seen = new HashSet<String>((int)Math.ceil((double)capacity / 0.75));
        }

        @Override
        public String nonConflictingName(String baseName) {
            while (!this.seen.add((String)baseName)) {
                baseName = (String)baseName + "_";
            }
            return baseName;
        }
    }

    public static class RefIndexDeduplicator
    extends StringDeduplicator {
        private final Index refIndex;
        private final Set<String> seen;

        RefIndexDeduplicator(Index refIndex, int capacity) {
            this.refIndex = refIndex;
            this.seen = new HashSet<String>((int)Math.ceil((double)capacity / 0.75));
        }

        @Override
        public String nonConflictingName(String baseName) {
            while (this.refIndex.contains((String)baseName) || !this.seen.add((String)baseName)) {
                baseName = (String)baseName + "_";
            }
            return baseName;
        }
    }
}

