/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.http;

import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import org.dflib.ByteSource;

class HttpByteSource
implements ByteSource {
    private final HttpClient client;
    private final HttpRequest request;

    public HttpByteSource(HttpClient client, HttpRequest request) {
        this.client = client;
        this.request = request;
    }

    @Override
    public Optional<String> uri() {
        return Optional.of(this.request.uri().toString());
    }

    @Override
    public InputStream stream() {
        HttpResponse<InputStream> response;
        try {
            response = this.client.send(this.request, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading HTTP response", e);
        }
        if (response.statusCode() != 200) {
            throw new RuntimeException("Bad response from the server for '" + String.valueOf(this.request.uri()) + "': " + response.statusCode());
        }
        return response.body();
    }
}

