/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.groupby;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.SeriesGroupBy;
import org.dflib.ValueMapper;
import org.dflib.builder.IntAccum;

public class SeriesGrouper<T> {
    private ValueMapper<T, ?> hasher;

    public SeriesGrouper(ValueMapper<T, ?> hasher) {
        this.hasher = hasher;
    }

    public SeriesGroupBy<T> group(Series<T> s) {
        LinkedHashMap<Object, IntSeries> groups = new LinkedHashMap<Object, IntSeries>();
        int len = s.size();
        for (int i = 0; i < len; ++i) {
            Object key = this.hasher.map(s.get(i));
            if (key == null) continue;
            ((IntAccum)groups.computeIfAbsent(key, k -> new IntAccum())).pushInt(i);
        }
        Iterator iterator = groups.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            e.setValue(((IntAccum)e.getValue()).toSeries());
        }
        return new SeriesGroupBy<T>(s, groups);
    }
}

