/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.groupby;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.GroupBy;
import org.dflib.Hasher;
import org.dflib.IntSeries;
import org.dflib.builder.IntAccum;
import org.dflib.row.RowProxy;

public class Grouper {
    private Hasher hasher;

    public Grouper(Hasher hasher) {
        this.hasher = Objects.requireNonNull(hasher, "Null 'hasher'");
    }

    public GroupBy group(DataFrame df) {
        LinkedHashMap<Object, IntSeries> groups = new LinkedHashMap<Object, IntSeries>();
        int i = 0;
        for (RowProxy rowProxy : df) {
            Object key = this.hasher.map(rowProxy);
            if (key != null) {
                ((IntAccum)groups.computeIfAbsent(key, k -> new IntAccum())).pushInt(i);
            }
            ++i;
        }
        for (Object object : groups.entrySet()) {
            Map.Entry e = (Map.Entry)object;
            e.setValue(((IntAccum)e.getValue()).toSeries());
        }
        return new GroupBy(df, groups, null);
    }
}

