/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.fs;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dflib.ByteSource;
import org.dflib.ByteSources;

public class FSFolder {
    private final Path folderPath;
    private final boolean includeSubfolders;
    private final Predicate<Path> extFilter;
    private final Predicate<Path> notHiddenFilter;

    public static FSFolder of(String fileName) {
        return FSFolder.of(new File(fileName));
    }

    public static FSFolder of(File file) {
        return FSFolder.of(file.toPath());
    }

    public static FSFolder of(Path path) {
        return new FSFolder(path, false, null, FSFolder::notHiddenFilter);
    }

    private FSFolder(Path folderPath, boolean includeSubfolders, Predicate<Path> extFilter, Predicate<Path> notHiddenFilter) {
        this.folderPath = Objects.requireNonNull(folderPath);
        this.includeSubfolders = includeSubfolders;
        this.extFilter = extFilter;
        this.notHiddenFilter = notHiddenFilter;
    }

    public Path getFolderPath() {
        return this.folderPath;
    }

    public FSFolder path(String subfolder) {
        Path other = Path.of(subfolder, new String[0]);
        if (other.isAbsolute()) {
            throw new IllegalArgumentException("Subfolder path can not use absolute path: " + subfolder);
        }
        Path subfolderPath = this.folderPath.resolve(other);
        return new FSFolder(subfolderPath, this.includeSubfolders, this.extFilter, this.notHiddenFilter);
    }

    public FSFolder includeHidden() {
        return new FSFolder(this.folderPath, this.includeSubfolders, this.extFilter, null);
    }

    public FSFolder includeExtension(String ext) {
        Objects.requireNonNull(ext);
        if (ext.isEmpty()) {
            throw new IllegalArgumentException("Empty extension");
        }
        Object normalizedExt = ext.startsWith(".") ? ext : "." + ext;
        return new FSFolder(this.folderPath, this.includeSubfolders, arg_0 -> FSFolder.lambda$includeExtension$0((String)normalizedExt, arg_0), this.notHiddenFilter);
    }

    public FSFolder includeSubfolders() {
        return this.includeSubfolders ? this : new FSFolder(this.folderPath, true, this.extFilter, this.notHiddenFilter);
    }

    public ByteSource source(String path) {
        return this.source(Path.of(path, new String[0]));
    }

    public ByteSource source(Path subPath) {
        return ByteSource.ofPath(this.folderPath.resolve(subPath));
    }

    public ByteSources sources() {
        HashMap sources = new HashMap();
        this.list().forEach(p -> sources.put(this.folderPath.relativize((Path)p).toString(), ByteSource.ofPath(p)));
        return ByteSources.of(sources);
    }

    public List<Path> list() {
        return this.list(false);
    }

    public List<Path> list(boolean includeFolders) {
        File root = this.folderPath.toFile();
        if (!root.isDirectory()) {
            throw new RuntimeException("Not a folder: " + String.valueOf(this.folderPath));
        }
        Predicate<Path> pathTypeFilter = includeFolders ? p -> true : x$0 -> Files.isRegularFile(x$0, new LinkOption[0]);
        Predicate filter = Stream.of(this.extFilter, this.notHiddenFilter).filter(f -> f != null).reduce(pathTypeFilter, Predicate::and);
        try {
            return Files.walk(this.folderPath, this.includeSubfolders ? Integer.MAX_VALUE : 1, new FileVisitOption[0]).filter(filter).sorted().collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean notHiddenFilter(Path path) {
        String name = path.getFileName().toString();
        return name.length() > 1 && name.charAt(0) != '.';
    }

    private static boolean matchesExtension(Path path, String ext) {
        return path.getFileName().toString().endsWith(ext);
    }

    private static /* synthetic */ boolean lambda$includeExtension$0(String normalizedExt, Path p) {
        return FSFolder.matchesExtension(p, normalizedExt);
    }
}

