/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.str;

import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.StrExp;
import org.dflib.builder.ObjectAccum;
import org.dflib.exp.ExpN;
import org.dflib.exp.str.StrScalarExp;

public class ConcatExp
extends ExpN<String>
implements StrExp {
    public static StrExp of(Object ... valuesOrExps) {
        int len = valuesOrExps.length;
        if (len == 0) {
            return new StrScalarExp(null);
        }
        Exp[] args = new Exp[len];
        for (int i = 0; i < len; ++i) {
            Object v = valuesOrExps[i];
            if (v == null) {
                return new StrScalarExp(null);
            }
            args[i] = v instanceof Exp ? (Exp)v : Exp.$val(v.toString());
        }
        return new ConcatExp(args);
    }

    protected ConcatExp(Exp<?>[] args) {
        super("concat", String.class, args);
    }

    @Override
    public Series<String> eval(Series<?> s) {
        int w = this.args.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.args[i].eval(s);
        }
        return this.doEval(s.size(), columns);
    }

    @Override
    public Series<String> eval(DataFrame df) {
        int w = this.args.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.args[i].eval(df);
        }
        return this.doEval(df.height(), columns);
    }

    @Override
    public String reduce(Series<?> s) {
        int w = this.args.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = Series.ofVal(this.args[i].reduce(s), 1);
        }
        return this.doEval(s.size(), columns).get(0);
    }

    @Override
    public String reduce(DataFrame df) {
        int w = this.args.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = Series.ofVal(this.args[i].reduce(df), 1);
        }
        return this.doEval(df.height(), columns).get(0);
    }

    private Series<String> doEval(int height, Series<?>[] args) {
        StringBuilder row = new StringBuilder();
        ObjectAccum<String> accum = new ObjectAccum<String>(height);
        for (int i = 0; i < height; ++i) {
            row.setLength(0);
            boolean isNull = false;
            for (Series<?> arg : args) {
                Object val = arg.get(i);
                if (val == null) {
                    isNull = true;
                    break;
                }
                row.append(val);
            }
            accum.push(isNull ? null : row.toString());
        }
        return accum.toSeries();
    }
}

