/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.num;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.dflib.Condition;
import org.dflib.DecimalExp;
import org.dflib.Exp;
import org.dflib.NumExp;
import org.dflib.exp.map.MapExp1;
import org.dflib.exp.num.BigintExp1;
import org.dflib.exp.num.BigintExpFactory;
import org.dflib.exp.num.DecimalExpFactory;
import org.dflib.exp.num.DoubleExp1;
import org.dflib.exp.num.DoubleExpFactory;
import org.dflib.exp.num.FloatExp1;
import org.dflib.exp.num.FloatExpFactory;
import org.dflib.exp.num.IntExp1;
import org.dflib.exp.num.IntExpFactory;
import org.dflib.exp.num.LongExp1;
import org.dflib.exp.num.LongExpFactory;

public abstract class NumericExpFactory {
    protected static final Map<Class<? extends Number>, Integer> typeConversionRank;
    protected static final Map<Class<? extends Number>, NumericExpFactory> factories;
    protected static final DecimalExpFactory decimalFactory;

    public static DecimalExpFactory decimalFactory() {
        return decimalFactory;
    }

    public static NumericExpFactory factory(Exp<? extends Number> exp) {
        return NumericExpFactory.factory(exp.getType());
    }

    public static NumericExpFactory factory(Class<? extends Number> type) {
        NumericExpFactory factory = factories.get(type);
        if (factory == null) {
            throw new IllegalArgumentException("Unsupported arithmetic type: " + String.valueOf(type));
        }
        return factory;
    }

    public static NumericExpFactory factory(Exp<? extends Number> left, Exp<? extends Number> right) {
        return NumericExpFactory.factory(left.getType(), right.getType());
    }

    public static NumericExpFactory factory(Class<? extends Number> left, Class<? extends Number> right) {
        Class<? extends Number> type = NumericExpFactory.factoryType(left, right);
        NumericExpFactory factory = factories.get(type);
        if (factory == null) {
            throw new IllegalArgumentException("Unsupported arithmetic type: " + String.valueOf(type));
        }
        return factory;
    }

    public static NumericExpFactory factory(Class<? extends Number> one, Class<? extends Number> two, Class<? extends Number> three) {
        Class<? extends Number> type = NumericExpFactory.factoryType(NumericExpFactory.factoryType(one, two), three);
        NumericExpFactory factory = factories.get(type);
        if (factory == null) {
            throw new IllegalArgumentException("Unsupported arithmetic type: " + String.valueOf(type));
        }
        return factory;
    }

    protected static Class<? extends Number> factoryType(Class<? extends Number> left, Class<? extends Number> right) {
        Integer lr = typeConversionRank.get(left);
        if (lr == null) {
            throw new IllegalArgumentException("Unsupported numeric type: " + String.valueOf(left));
        }
        Integer rr = typeConversionRank.get(right);
        if (rr == null) {
            throw new IllegalArgumentException("Unsupported numeric type: " + String.valueOf(right));
        }
        return lr.compareTo(rr) < 0 ? left : right;
    }

    public abstract NumExp<?> add(Exp<? extends Number> var1, Exp<? extends Number> var2);

    public abstract NumExp<?> sub(Exp<? extends Number> var1, Exp<? extends Number> var2);

    public abstract NumExp<?> mul(Exp<? extends Number> var1, Exp<? extends Number> var2);

    public abstract NumExp<?> div(Exp<? extends Number> var1, Exp<? extends Number> var2);

    public abstract NumExp<?> mod(Exp<? extends Number> var1, Exp<? extends Number> var2);

    public abstract NumExp<?> abs(Exp<? extends Number> var1);

    public abstract NumExp<?> cumSum(Exp<? extends Number> var1);

    @Deprecated(since="2.0.0", forRemoval=true)
    public NumExp<?> sum(Exp<? extends Number> exp) {
        return this.sum(exp, null);
    }

    public abstract NumExp<?> sum(Exp<? extends Number> var1, Condition var2);

    @Deprecated(since="2.0.0", forRemoval=true)
    public NumExp<?> min(Exp<? extends Number> exp) {
        return this.min(exp, null);
    }

    public abstract NumExp<?> min(Exp<? extends Number> var1, Condition var2);

    @Deprecated(since="2.0.0", forRemoval=true)
    public NumExp<?> max(Exp<? extends Number> exp) {
        return this.max(exp, null);
    }

    public abstract NumExp<?> max(Exp<? extends Number> var1, Condition var2);

    @Deprecated(since="2.0.0", forRemoval=true)
    public NumExp<?> avg(Exp<? extends Number> exp) {
        return this.avg(exp, null);
    }

    public abstract NumExp<?> avg(Exp<? extends Number> var1, Condition var2);

    @Deprecated(since="2.0.0", forRemoval=true)
    public NumExp<?> median(Exp<? extends Number> exp) {
        return this.median(exp, null);
    }

    public abstract NumExp<?> median(Exp<? extends Number> var1, Condition var2);

    public abstract NumExp<?> quantile(Exp<? extends Number> var1, double var2, Condition var4);

    public abstract NumExp<?> round(Exp<? extends Number> var1);

    public NumExp<Integer> castAsInt(NumExp<?> exp) {
        return IntExp1.mapVal("castAsInt", exp, Number::intValue);
    }

    public NumExp<Long> castAsLong(NumExp<?> exp) {
        return LongExp1.mapVal("castAsLong", exp, Number::longValue);
    }

    public NumExp<Double> castAsDouble(NumExp<?> exp) {
        return DoubleExp1.mapVal("castAsDouble", exp, Number::doubleValue);
    }

    public NumExp<Float> castAsFloat(NumExp<?> exp) {
        return FloatExp1.mapVal("castAsFloat", exp, Number::floatValue);
    }

    public NumExp<BigInteger> castAsBigint(NumExp<?> exp) {
        return BigintExp1.mapVal("castAsBigint", exp, n -> BigInteger.valueOf(n.longValue()));
    }

    public abstract DecimalExp castAsDecimal(NumExp<?> var1);

    public <E extends Enum<E>> Exp<E> castAsEnum(NumExp<?> exp, Class<E> type) {
        Enum[] allValues = (Enum[])type.getEnumConstants();
        NumExp<?> noGenericExp = exp;
        return MapExp1.mapVal("castAsEnum", type, noGenericExp, i -> allValues[i.intValue()]);
    }

    public abstract Condition eq(Exp<? extends Number> var1, Exp<? extends Number> var2);

    public abstract Condition ne(Exp<? extends Number> var1, Exp<? extends Number> var2);

    public abstract Condition lt(Exp<? extends Number> var1, Exp<? extends Number> var2);

    public abstract Condition le(Exp<? extends Number> var1, Exp<? extends Number> var2);

    public abstract Condition gt(Exp<? extends Number> var1, Exp<? extends Number> var2);

    public abstract Condition ge(Exp<? extends Number> var1, Exp<? extends Number> var2);

    public abstract Condition between(Exp<? extends Number> var1, Exp<? extends Number> var2, Exp<? extends Number> var3);

    static {
        decimalFactory = new DecimalExpFactory();
        typeConversionRank = new HashMap<Class<? extends Number>, Integer>();
        typeConversionRank.put(BigDecimal.class, 0);
        typeConversionRank.put(Double.class, 1);
        typeConversionRank.put(Double.TYPE, 1);
        typeConversionRank.put(Float.class, 2);
        typeConversionRank.put(Float.TYPE, 2);
        typeConversionRank.put(BigInteger.class, 3);
        typeConversionRank.put(Long.class, 4);
        typeConversionRank.put(Long.TYPE, 4);
        typeConversionRank.put(Integer.class, 5);
        typeConversionRank.put(Integer.TYPE, 5);
        factories = new HashMap<Class<? extends Number>, NumericExpFactory>();
        factories.put(BigDecimal.class, decimalFactory);
        factories.put(BigInteger.class, new BigintExpFactory());
        factories.put(Float.class, new FloatExpFactory());
        factories.put(Float.TYPE, factories.get(Float.class));
        factories.put(Double.class, new DoubleExpFactory());
        factories.put(Double.TYPE, factories.get(Double.class));
        factories.put(Integer.class, new IntExpFactory());
        factories.put(Integer.TYPE, factories.get(Integer.class));
        factories.put(Long.class, new LongExpFactory());
        factories.put(Long.TYPE, factories.get(Long.class));
    }
}

