/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.num;

import java.math.BigDecimal;
import org.dflib.Condition;
import org.dflib.DecimalExp;
import org.dflib.Exp;
import org.dflib.IntSeries;
import org.dflib.NumExp;
import org.dflib.agg.Percentiles;
import org.dflib.exp.agg.DoubleAggregators;
import org.dflib.exp.agg.DoubleReduceExp1;
import org.dflib.exp.agg.IntAggregators;
import org.dflib.exp.agg.IntReduceExp1;
import org.dflib.exp.num.DecimalExp1;
import org.dflib.exp.num.IntCondition2;
import org.dflib.exp.num.IntCondition3;
import org.dflib.exp.num.IntExp1;
import org.dflib.exp.num.IntExp2;
import org.dflib.exp.num.LongExp1;
import org.dflib.exp.num.NumericExpFactory;

public class IntExpFactory
extends NumericExpFactory {
    protected static Exp<Integer> cast(Exp<?> exp) {
        Class<?> t = exp.getType();
        if (t.equals(Integer.class) || t.equals(Integer.TYPE)) {
            return exp;
        }
        if (Number.class.isAssignableFrom(t)) {
            Exp<Integer> nExp = exp;
            return IntExp1.mapVal("castAsInt", nExp, Number::intValue);
        }
        if (t.equals(String.class)) {
            Exp<Integer> sExp = exp;
            return IntExp1.mapVal("castAsInt", sExp, Integer::parseInt);
        }
        throw new IllegalArgumentException("Expression type '" + t.getName() + "' can't be converted to Integer");
    }

    @Override
    public NumExp<?> add(Exp<? extends Number> left, Exp<? extends Number> right) {
        return IntExp2.mapVal("+", IntExpFactory.cast(left), IntExpFactory.cast(right), (n1, n2) -> n1 + n2, IntSeries::add);
    }

    @Override
    public NumExp<?> sub(Exp<? extends Number> left, Exp<? extends Number> right) {
        return IntExp2.mapVal("-", IntExpFactory.cast(left), IntExpFactory.cast(right), (n1, n2) -> n1 - n2, IntSeries::sub);
    }

    @Override
    public NumExp<?> mul(Exp<? extends Number> left, Exp<? extends Number> right) {
        return IntExp2.mapVal("*", IntExpFactory.cast(left), IntExpFactory.cast(right), (n1, n2) -> n1 * n2, IntSeries::mul);
    }

    @Override
    public NumExp<?> div(Exp<? extends Number> left, Exp<? extends Number> right) {
        return IntExp2.mapVal("/", IntExpFactory.cast(left), IntExpFactory.cast(right), (n1, n2) -> n1 / n2, IntSeries::div);
    }

    @Override
    public NumExp<?> mod(Exp<? extends Number> left, Exp<? extends Number> right) {
        return IntExp2.mapVal("%", IntExpFactory.cast(left), IntExpFactory.cast(right), (n1, n2) -> n1 % n2, IntSeries::mod);
    }

    @Override
    public NumExp<?> abs(Exp<? extends Number> exp) {
        return IntExp1.mapVal("abs", IntExpFactory.cast(exp), Math::abs);
    }

    @Override
    public DecimalExp castAsDecimal(NumExp<?> exp) {
        return DecimalExp1.mapVal("castAsDecimal", IntExpFactory.cast(exp), BigDecimal::valueOf);
    }

    public NumExp<Long> cumSum(Exp<? extends Number> exp) {
        return LongExp1.map("cumSum", exp, IntAggregators::cumSum);
    }

    public NumExp<Integer> sum(Exp<? extends Number> exp, Condition filter) {
        return new IntReduceExp1<Number>("sum", exp, IntAggregators::sum, filter);
    }

    @Override
    public NumExp<?> min(Exp<? extends Number> exp, Condition filter) {
        return new IntReduceExp1<Number>("min", exp, IntAggregators::min, filter);
    }

    @Override
    public NumExp<?> max(Exp<? extends Number> exp, Condition filter) {
        return new IntReduceExp1<Number>("max", exp, IntAggregators::max, filter);
    }

    @Override
    public NumExp<?> avg(Exp<? extends Number> exp, Condition filter) {
        return new DoubleReduceExp1<Number>("avg", exp, DoubleAggregators::avg, filter);
    }

    @Override
    public NumExp<?> median(Exp<? extends Number> exp, Condition filter) {
        return new DoubleReduceExp1<Number>("median", exp, s -> Percentiles.ofDoubles(s, 0.5), filter);
    }

    @Override
    public NumExp<?> quantile(Exp<? extends Number> exp, double q, Condition filter) {
        return new DoubleReduceExp1<Number>("quantile", exp, s -> Percentiles.ofDoubles(s, q), filter);
    }

    public NumExp<Integer> round(Exp<? extends Number> exp) {
        return IntExpFactory.cast(exp).castAsInt();
    }

    @Override
    public Condition eq(Exp<? extends Number> left, Exp<? extends Number> right) {
        return IntCondition2.mapVal("=", IntExpFactory.cast(left), IntExpFactory.cast(right), Integer::equals, IntSeries::eq);
    }

    @Override
    public Condition ne(Exp<? extends Number> left, Exp<? extends Number> right) {
        return IntCondition2.mapVal("!=", IntExpFactory.cast(left), IntExpFactory.cast(right), (n1, n2) -> !n1.equals(n2), IntSeries::ne);
    }

    @Override
    public Condition lt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return IntCondition2.mapVal("<", IntExpFactory.cast(left), IntExpFactory.cast(right), (n1, n2) -> n1 < n2, IntSeries::lt);
    }

    @Override
    public Condition le(Exp<? extends Number> left, Exp<? extends Number> right) {
        return IntCondition2.mapVal("<=", IntExpFactory.cast(left), IntExpFactory.cast(right), (n1, n2) -> n1 <= n2, IntSeries::le);
    }

    @Override
    public Condition gt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return IntCondition2.mapVal(">", IntExpFactory.cast(left), IntExpFactory.cast(right), (n1, n2) -> n1 > n2, IntSeries::gt);
    }

    @Override
    public Condition ge(Exp<? extends Number> left, Exp<? extends Number> right) {
        return IntCondition2.mapVal(">=", IntExpFactory.cast(left), IntExpFactory.cast(right), (n1, n2) -> n1 >= n2, IntSeries::ge);
    }

    @Override
    public Condition between(Exp<? extends Number> left, Exp<? extends Number> from, Exp<? extends Number> to) {
        return IntCondition3.mapVal("between", "and", IntExpFactory.cast(left), IntExpFactory.cast(from), IntExpFactory.cast(to), (n1, n2, n3) -> n1 >= n2 && n1 <= n3, IntSeries::between);
    }
}

