/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.num;

import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import org.dflib.Exp;
import org.dflib.FloatSeries;
import org.dflib.NumExp;
import org.dflib.Series;
import org.dflib.exp.map.MapExp2;

public class FloatExp2
extends MapExp2<Float, Float, Float>
implements NumExp<Float> {
    private final BinaryOperator<FloatSeries> primitiveOp;

    public static FloatExp2 mapVal(String opName, Exp<Float> left, Exp<Float> right, BiFunction<Float, Float, Float> op, BinaryOperator<FloatSeries> primitiveOp) {
        return new FloatExp2(opName, left, right, FloatExp2.valToSeries(op), primitiveOp);
    }

    protected FloatExp2(String opName, Exp<Float> left, Exp<Float> right, BiFunction<Series<Float>, Series<Float>, Series<Float>> op, BinaryOperator<FloatSeries> primitiveOp) {
        super(opName, Float.class, left, right, op);
        this.primitiveOp = primitiveOp;
    }

    @Override
    protected Series<Float> doEval(Series<Float> ls, Series<Float> rs) {
        return ls instanceof FloatSeries && rs instanceof FloatSeries ? (Series)this.primitiveOp.apply((FloatSeries)ls, (FloatSeries)rs) : super.doEval(ls, rs);
    }

    @Override
    public NumExp<Float> castAsFloat() {
        return this;
    }
}

