/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.num;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.dflib.Condition;
import org.dflib.DecimalExp;
import org.dflib.Exp;
import org.dflib.NumExp;
import org.dflib.agg.Percentiles;
import org.dflib.exp.agg.BigintAggregators;
import org.dflib.exp.agg.BigintReduceExp1;
import org.dflib.exp.agg.ComparableAggregators;
import org.dflib.exp.agg.DecimalReduceExp1;
import org.dflib.exp.map.MapCondition2;
import org.dflib.exp.map.MapCondition3;
import org.dflib.exp.num.BigintExp1;
import org.dflib.exp.num.BigintExp2;
import org.dflib.exp.num.DecimalExpFactory;
import org.dflib.exp.num.NumericExpFactory;

public class BigintExpFactory
extends NumericExpFactory {
    protected static Exp<BigInteger> cast(Exp<?> exp) {
        Class<?> t = exp.getType();
        if (t.equals(BigInteger.class)) {
            return exp;
        }
        if (t.equals(BigDecimal.class)) {
            Exp<BigInteger> bdExp = exp;
            return BigintExp1.mapVal("castAsBigint", bdExp, BigDecimal::toBigInteger);
        }
        if (Number.class.isAssignableFrom(t)) {
            Exp<BigInteger> nExp = exp;
            return BigintExp1.mapVal("castAsBigint", nExp, n -> BigInteger.valueOf(n.longValue()));
        }
        if (t.equals(String.class)) {
            Exp<BigInteger> sExp = exp;
            return BigintExp1.mapVal("castAsBigint", sExp, BigInteger::new);
        }
        throw new IllegalArgumentException("Expression type '" + t.getName() + "' can't be converted to 'bigint'");
    }

    public NumExp<BigInteger> add(Exp<? extends Number> left, Exp<? extends Number> right) {
        return BigintExp2.mapVal("+", BigintExpFactory.cast(left), BigintExpFactory.cast(right), BigInteger::add);
    }

    public NumExp<BigInteger> sub(Exp<? extends Number> left, Exp<? extends Number> right) {
        return BigintExp2.mapVal("-", BigintExpFactory.cast(left), BigintExpFactory.cast(right), BigInteger::subtract);
    }

    public NumExp<BigInteger> mul(Exp<? extends Number> left, Exp<? extends Number> right) {
        return BigintExp2.mapVal("*", BigintExpFactory.cast(left), BigintExpFactory.cast(right), BigInteger::multiply);
    }

    public NumExp<BigInteger> div(Exp<? extends Number> left, Exp<? extends Number> right) {
        return BigintExp2.mapVal("/", BigintExpFactory.cast(left), BigintExpFactory.cast(right), BigInteger::divide);
    }

    public NumExp<BigInteger> mod(Exp<? extends Number> left, Exp<? extends Number> right) {
        return BigintExp2.mapVal("%", BigintExpFactory.cast(left), BigintExpFactory.cast(right), BigInteger::remainder);
    }

    public NumExp<BigInteger> abs(Exp<? extends Number> exp) {
        return BigintExp1.mapVal("abs", BigintExpFactory.cast(exp), BigInteger::abs);
    }

    @Override
    public NumExp<BigInteger> castAsBigint(NumExp<?> exp) {
        return (NumExp)BigintExpFactory.cast(exp);
    }

    @Override
    public DecimalExp castAsDecimal(NumExp<?> exp) {
        return DecimalExpFactory.cast(exp);
    }

    public NumExp<BigInteger> cumSum(Exp<? extends Number> exp) {
        return BigintExp1.map("cumSum", BigintExpFactory.cast(exp), BigintAggregators::cumSum);
    }

    @Deprecated
    public NumExp<BigInteger> sum(Exp<? extends Number> exp) {
        return this.sum(exp, null);
    }

    public NumExp<BigInteger> sum(Exp<? extends Number> exp, Condition filter) {
        return new BigintReduceExp1<BigInteger>("sum", BigintExpFactory.cast(exp), BigintAggregators::sum, filter);
    }

    @Deprecated
    public NumExp<BigInteger> min(Exp<? extends Number> exp) {
        return this.min(exp, null);
    }

    public NumExp<BigInteger> min(Exp<? extends Number> exp, Condition filter) {
        return new BigintReduceExp1<BigInteger>("min", BigintExpFactory.cast(exp), ComparableAggregators::min, filter);
    }

    @Deprecated
    public NumExp<BigInteger> max(Exp<? extends Number> exp) {
        return this.max(exp, null);
    }

    public NumExp<BigInteger> max(Exp<? extends Number> exp, Condition filter) {
        return new BigintReduceExp1<BigInteger>("max", BigintExpFactory.cast(exp), ComparableAggregators::max, filter);
    }

    public NumExp<BigDecimal> avg(Exp<? extends Number> exp, Condition filter) {
        return new DecimalReduceExp1<BigInteger>("avg", BigintExpFactory.cast(exp), BigintAggregators::avg, filter);
    }

    public DecimalExp median(Exp<? extends Number> exp, Condition filter) {
        return new DecimalReduceExp1<BigInteger>("median", BigintExpFactory.cast(exp), s -> Percentiles.ofBigints(s, 0.5), filter);
    }

    public DecimalExp quantile(Exp<? extends Number> exp, double q, Condition filter) {
        return new DecimalReduceExp1<BigInteger>("quantile", BigintExpFactory.cast(exp), s -> Percentiles.ofBigints(s, q), filter);
    }

    public NumExp<BigInteger> round(Exp<? extends Number> exp) {
        return (NumExp)BigintExpFactory.cast(exp);
    }

    @Override
    public Condition eq(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal("=", BigintExpFactory.cast(left), BigintExpFactory.cast(right), BigInteger::equals);
    }

    @Override
    public Condition ne(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal("!=", BigintExpFactory.cast(left), BigintExpFactory.cast(right), (n1, n2) -> !n1.equals(n2));
    }

    @Override
    public Condition lt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal("<", BigintExpFactory.cast(left), BigintExpFactory.cast(right), (n1, n2) -> n1.compareTo((BigInteger)n2) < 0);
    }

    @Override
    public Condition le(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal("<=", BigintExpFactory.cast(left), BigintExpFactory.cast(right), (n1, n2) -> n1.compareTo((BigInteger)n2) <= 0);
    }

    @Override
    public Condition gt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal(">", BigintExpFactory.cast(left), BigintExpFactory.cast(right), (n1, n2) -> n1.compareTo((BigInteger)n2) > 0);
    }

    @Override
    public Condition ge(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal(">=", BigintExpFactory.cast(left), BigintExpFactory.cast(right), (n1, n2) -> n1.compareTo((BigInteger)n2) >= 0);
    }

    @Override
    public Condition between(Exp<? extends Number> left, Exp<? extends Number> from, Exp<? extends Number> to) {
        return MapCondition3.mapVal("between", "and", BigintExpFactory.cast(left), BigintExpFactory.cast(from), BigintExpFactory.cast(to), (n1, n2, n3) -> n1.compareTo((BigInteger)n2) >= 0 && n1.compareTo((BigInteger)n3) <= 0);
    }
}

