/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.bool;

import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Series;
import org.dflib.exp.ExpN;
import org.dflib.exp.bool.AndCondition;

public class OrCondition
extends ExpN<Boolean>
implements Condition {
    private final Condition[] conditionArgs;

    public OrCondition(Condition ... args) {
        super("or", Boolean.class, args);
        this.conditionArgs = args;
    }

    @Override
    public Condition or(Condition exp) {
        return exp.getClass().equals(OrCondition.class) ? new OrCondition(AndCondition.combine(this.args, ((OrCondition)exp).args)) : new OrCondition(AndCondition.combine(this.args, exp));
    }

    @Override
    public int firstMatch(DataFrame df) {
        int len = this.args.length;
        int r = -1;
        for (int i = 0; i < len; ++i) {
            int rx = ((Condition)this.args[i]).firstMatch(df);
            int n = r = r < 0 ? rx : Math.min(r, rx);
            if (r != 0) continue;
            return 0;
        }
        return r;
    }

    @Override
    public int firstMatch(Series<?> s) {
        int len = this.args.length;
        int r = -1;
        for (int i = 0; i < len; ++i) {
            int rx = ((Condition)this.args[i]).firstMatch(s);
            int n = r = r < 0 ? rx : Math.min(r, rx);
            if (r != 0) continue;
            return 0;
        }
        return r;
    }

    @Override
    public BooleanSeries eval(Series<?> s) {
        int w = this.args.length;
        BooleanSeries[] columns = new BooleanSeries[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.conditionArgs[i].eval((Series)s);
        }
        return BooleanSeries.orAll(columns);
    }

    @Override
    public BooleanSeries eval(DataFrame df) {
        int w = this.args.length;
        BooleanSeries[] columns = new BooleanSeries[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.conditionArgs[i].eval(df);
        }
        return BooleanSeries.orAll(columns);
    }

    @Override
    public Boolean reduce(Series<?> s) {
        int w = this.args.length;
        BooleanSeries[] columns = new BooleanSeries[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = Series.ofBool((Boolean)this.conditionArgs[i].reduce(s));
        }
        return BooleanSeries.orAll(columns).get(0);
    }

    @Override
    public Boolean reduce(DataFrame df) {
        int w = this.args.length;
        BooleanSeries[] columns = new BooleanSeries[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = Series.ofBool((Boolean)this.conditionArgs[i].reduce(df));
        }
        return BooleanSeries.orAll(columns).get(0);
    }
}

