/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import java.util.function.BiFunction;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.exp.Exp2;

public class ReduceExp2<L, R, T>
extends Exp2<L, R, T> {
    private final BiFunction<Series<L>, Series<R>, T> op;
    private final Condition filter;

    public ReduceExp2(String opName, Class<T> type, Exp<L> left, Exp<R> right, BiFunction<Series<L>, Series<R>, T> op, Condition filter) {
        super(opName, type, left, right);
        this.op = op;
        this.filter = filter;
    }

    @Override
    public String toQL() {
        return this.opName + "(" + this.left.toQL() + "," + this.right.toQL() + ")";
    }

    @Override
    public String toQL(DataFrame df) {
        return this.opName + "(" + this.left.toQL(df) + "," + this.right.toQL(df) + ")";
    }

    @Override
    public Series<T> eval(Series<?> s) {
        return Series.ofVal(this.reduce(s), s.size());
    }

    @Override
    public Series<T> eval(DataFrame df) {
        return Series.ofVal(this.reduce(df), df.height());
    }

    @Override
    public T reduce(DataFrame df) {
        DataFrame dff = this.filter != null ? df.rows(this.filter).select() : df;
        return this.op.apply(this.left.eval(dff), this.right.eval(dff));
    }

    @Override
    public T reduce(Series<?> s) {
        Series<?> sf = this.filter != null ? s.select(this.filter) : s;
        return this.op.apply(this.left.eval(sf), this.right.eval(sf));
    }
}

