/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.builder.ObjectAccum;

public class IntAggregators {
    public static Series<Long> cumSum(Series<? extends Number> s) {
        Number next;
        int i;
        int h = s.size();
        if (h == 0) {
            return Series.ofLong(new long[0]);
        }
        if (s instanceof IntSeries) {
            return ((IntSeries)s).cumSum();
        }
        ObjectAccum<Long> accum = new ObjectAccum<Long>(h);
        long runningTotal = 0L;
        for (i = 0; i < h; ++i) {
            next = s.get(i);
            if (next != null) {
                runningTotal = next.intValue();
                accum.push(runningTotal);
                ++i;
                break;
            }
            accum.push(null);
        }
        while (i < h) {
            next = s.get(i);
            if (next == null) {
                accum.push(null);
            } else {
                accum.push(runningTotal += (long)next.intValue());
            }
            ++i;
        }
        return accum.toSeries();
    }

    public static int sum(Series<? extends Number> s) {
        int h = s.size();
        if (h == 0) {
            return 0;
        }
        if (s instanceof IntSeries) {
            return (int)((IntSeries)s).sum();
        }
        int sum = 0;
        for (int i = 0; i < h; ++i) {
            Number n = s.get(i);
            if (n == null) continue;
            sum += n.intValue();
        }
        return sum;
    }

    public static int min(Series<? extends Number> s) {
        int size = s.size();
        if (size == 0) {
            return 0;
        }
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            int in;
            Number n = s.get(i);
            if (n == null || (in = n.intValue()) >= min) continue;
            min = in;
        }
        return min;
    }

    public static int max(Series<? extends Number> s) {
        int size = s.size();
        if (size == 0) {
            return 0;
        }
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            int in;
            Number n = s.get(i);
            if (n == null || (in = n.intValue()) <= max) continue;
            max = in;
        }
        return max;
    }
}

