/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import java.math.BigDecimal;
import org.dflib.DecimalExp;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.agg.Percentiles;
import org.dflib.builder.ObjectAccum;

public class DecimalAggregators {
    private static final DecimalExp avg = Exp.$decimal(0).sum().div(Exp.count());

    public static Series<BigDecimal> cumSum(Series<BigDecimal> s) {
        int i;
        int h = s.size();
        if (h == 0) {
            return s;
        }
        ObjectAccum<BigDecimal> accum = new ObjectAccum<BigDecimal>(h);
        BigDecimal runningTotal = null;
        for (i = 0; i < h && runningTotal == null; ++i) {
            runningTotal = s.get(i);
            accum.push(runningTotal);
        }
        while (i < h) {
            BigDecimal next = s.get(i);
            if (next == null) {
                accum.push(null);
            } else {
                runningTotal = runningTotal.add(next);
                accum.push(runningTotal);
            }
            ++i;
        }
        return accum.toSeries();
    }

    public static BigDecimal sum(Series<BigDecimal> s) {
        int size = s.size();
        if (size == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = s.get(0);
        for (int i = 1; i < size; ++i) {
            BigDecimal d = s.get(i);
            if (d == null) continue;
            sum = sum.add(d);
        }
        return sum;
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static BigDecimal median(Series<BigDecimal> s) {
        return Percentiles.ofDecimals(s, 0.5);
    }

    public static BigDecimal avg(Series<BigDecimal> s) {
        return s.size() == 0 ? BigDecimal.ZERO : (BigDecimal)avg.reduce(s);
    }
}

