/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.NumExp;
import org.dflib.Series;
import org.dflib.exp.Exp0;

public class CountExp
extends Exp0<Integer>
implements NumExp<Integer> {
    private static final CountExp instance = new CountExp(null);
    private final Condition filter;

    public static CountExp getInstance() {
        return instance;
    }

    public CountExp(Condition filter) {
        super("count", Integer.class);
        this.filter = filter;
    }

    @Override
    public Series<Integer> eval(DataFrame df) {
        return Series.ofVal(this.reduce(df), df.height());
    }

    @Override
    public Series<Integer> eval(Series<?> s) {
        return Series.ofVal(this.reduce((Series)s), s.size());
    }

    @Override
    public Integer reduce(DataFrame df) {
        return this.filter != null ? this.filter.eval(df).countTrue() : df.height();
    }

    @Override
    public Integer reduce(Series<?> s) {
        return this.filter != null ? this.filter.eval((Series)s).countTrue() : s.size();
    }
}

