/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.dflib.Series;
import org.dflib.ValueMapper;

public class CollectorAggregator<S, A, T>
implements Function<Series<S>, T> {
    private final Collector<S, A, T> collector;

    public static <S, T> Function<Series<S>, T> create(Collector<S, ?, T> collector) {
        return new CollectorAggregator(collector);
    }

    public static <S, M, A, T> Function<Series<S>, T> create(final Collector<M, A, T> collector, final ValueMapper<S, M> mapper) {
        Collector mapped = new Collector<S, A, T>(){

            @Override
            public Supplier<A> supplier() {
                return collector.supplier();
            }

            @Override
            public BiConsumer<A, S> accumulator() {
                BiConsumer accum = collector.accumulator();
                return (a, s) -> accum.accept(a, mapper.map(s));
            }

            @Override
            public BinaryOperator<A> combiner() {
                return collector.combiner();
            }

            @Override
            public Function<A, T> finisher() {
                return collector.finisher();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return collector.characteristics();
            }
        };
        return new CollectorAggregator<S, A, T>(mapped);
    }

    private CollectorAggregator(Collector<S, A, T> collector) {
        this.collector = collector;
    }

    @Override
    public T apply(Series<S> s) {
        BiConsumer<A, S> accum = this.collector.accumulator();
        A result = this.collector.supplier().get();
        int len = s.size();
        for (int i = 0; i < len; ++i) {
            accum.accept(result, s.get(i));
        }
        return this.collector.finisher().apply(result);
    }
}

