/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.dflib.DecimalExp;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.builder.ObjectAccum;

public class BigintAggregators {
    private static final DecimalExp avg = Exp.$bigint(0).sum().castAsDecimal().div(Exp.count());

    public static Series<BigInteger> cumSum(Series<BigInteger> s) {
        int i;
        int h = s.size();
        if (h == 0) {
            return s;
        }
        ObjectAccum<BigInteger> accum = new ObjectAccum<BigInteger>(h);
        BigInteger runningTotal = null;
        for (i = 0; i < h && runningTotal == null; ++i) {
            runningTotal = s.get(i);
            accum.push(runningTotal);
        }
        while (i < h) {
            BigInteger next = s.get(i);
            if (next == null) {
                accum.push(null);
            } else {
                runningTotal = runningTotal.add(next);
                accum.push(runningTotal);
            }
            ++i;
        }
        return accum.toSeries();
    }

    public static BigInteger sum(Series<BigInteger> s) {
        int size = s.size();
        if (size == 0) {
            return BigInteger.ZERO;
        }
        BigInteger sum = s.get(0);
        for (int i = 1; i < size; ++i) {
            BigInteger d = s.get(i);
            if (d == null) continue;
            sum = sum.add(d);
        }
        return sum;
    }

    public static BigDecimal avg(Series<BigInteger> s) {
        return s.size() == 0 ? BigDecimal.ZERO : (BigDecimal)avg.reduce(s);
    }
}

