/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp;

import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.exp.ScalarExp;

public class ShiftExp<T>
implements Exp<T> {
    private final Exp<T> delegate;
    private final int offset;
    private final T filler;

    public ShiftExp(Exp<T> delegate, int offset, T filler) {
        this.delegate = Objects.requireNonNull(delegate);
        this.offset = offset;
        this.filler = filler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftExp shiftExp = (ShiftExp)o;
        return this.offset == shiftExp.offset && Objects.equals(this.delegate, shiftExp.delegate) && Objects.equals(this.filler, shiftExp.filler);
    }

    public int hashCode() {
        return Objects.hash(this.delegate, this.offset, this.filler);
    }

    @Override
    public Class<T> getType() {
        return this.delegate.getType();
    }

    @Override
    public String toQL() {
        return "shift(" + this.delegate.toQL() + "," + this.offset + "," + ScalarExp.scalarToQL(this.filler) + ")";
    }

    @Override
    public String toQL(DataFrame df) {
        return "shift(" + this.delegate.toQL(df) + "," + this.offset + "," + ScalarExp.scalarToQL(this.filler) + ")";
    }

    @Override
    public Series<T> eval(DataFrame df) {
        return this.delegate.eval(df).shift(this.offset, this.filler);
    }

    @Override
    public Series<T> eval(Series<?> s) {
        return this.delegate.eval(s).shift(this.offset, this.filler);
    }

    @Override
    public T reduce(Series<?> s) {
        throw new UnsupportedOperationException("Shift expression does not define a 'reduce' operation");
    }

    @Override
    public T reduce(DataFrame df) {
        throw new UnsupportedOperationException("Shift expression does not define a 'reduce' operation");
    }
}

