/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dflib.DataFrame;
import org.dflib.Exp;

public abstract class ExpN<T>
implements Exp<T> {
    private final String opName;
    private final Class<T> type;
    protected final Exp<?>[] args;

    public ExpN(String opName, Class<T> type, Exp<?> ... args) {
        this.opName = opName;
        this.type = type;
        this.args = args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpN expN = (ExpN)o;
        return Objects.equals(this.opName, expN.opName) && Objects.equals(this.type, expN.type) && Objects.deepEquals(this.args, expN.args);
    }

    public int hashCode() {
        return Objects.hash(this.opName, this.type, Arrays.hashCode(this.args));
    }

    public String toString() {
        return this.toQL();
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public String toQL() {
        return Arrays.stream(this.args).map((? super T a) -> a.toQL()).collect(Collectors.joining(",", this.opName + "(", ")"));
    }

    @Override
    public String toQL(DataFrame df) {
        return Arrays.stream(this.args).map((? super T a) -> a.toQL(df)).collect(Collectors.joining(",", this.opName + "(", ")"));
    }
}

