/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp;

import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;

public class Column<T>
implements Exp<T> {
    protected final int position;
    protected final String name;
    private final Class<T> type;

    public Column(String name, Class<T> type) {
        this.type = Objects.requireNonNull(type);
        this.name = Objects.requireNonNull(name);
        this.position = -1;
    }

    public Column(int position, Class<T> type) {
        if (position < 0) {
            throw new IllegalArgumentException("Position must not be negative: " + position);
        }
        this.type = Objects.requireNonNull(type);
        this.name = null;
        this.position = position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        return this.position == column.position && Objects.equals(this.name, column.name) && Objects.equals(this.type, column.type);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.name, this.type);
    }

    public String toString() {
        return this.toQL();
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public String toQL() {
        return this.position >= 0 ? "$col(" + this.position + ")" : this.name;
    }

    @Override
    public String toQL(DataFrame df) {
        return this.position >= 0 ? df.getColumnsIndex().get(this.position) : this.name;
    }

    @Override
    public Series<T> eval(DataFrame df) {
        return this.position >= 0 ? df.getColumn(this.position) : df.getColumn(this.name);
    }

    @Override
    public Series<T> eval(Series<?> s) {
        return s;
    }

    @Override
    public T reduce(DataFrame df) {
        return this.eval(df).first();
    }

    @Override
    public T reduce(Series<?> s) {
        return this.eval(s).first();
    }
}

