/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.codec;

import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import org.dflib.ByteSource;
import org.dflib.codec.GzipCodec;

public interface Codec {
    public static final Codec GZIP = new GzipCodec();

    public static Optional<Codec> ofUri(String uri) {
        String extension;
        Objects.requireNonNull(uri);
        int dot = uri.lastIndexOf(46);
        if (dot < 0 || dot == uri.length() - 1) {
            return Optional.empty();
        }
        switch (extension = uri.substring(dot + 1)) {
            case "gz": 
            case "gzip": {
                return Optional.of(GZIP);
            }
        }
        return Optional.empty();
    }

    public ByteSource decompress(ByteSource var1);

    @Deprecated(since="2.0.0", forRemoval=true)
    public OutputStream compress(OutputStream var1);
}

