/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import org.dflib.Extractor;
import org.dflib.builder.ObjectHolder;
import org.dflib.builder.SingleValueAccum;
import org.dflib.builder.ValueAccum;
import org.dflib.builder.ValueHolder;
import org.dflib.builder.ValueStore;

public class SingleValueExtractor<F, T>
implements Extractor<F, T> {
    private final T value;

    public SingleValueExtractor(T value) {
        this.value = value;
    }

    @Override
    public Extractor<F, T> compact() {
        return this;
    }

    @Override
    public void extractAndStore(F from, ValueStore<T> to) {
        to.push(this.value);
    }

    @Override
    public void extractAndStore(F from, ValueStore<T> to, int toPos) {
        to.replace(toPos, this.value);
    }

    @Override
    public ValueAccum<T> createAccum(int capacity) {
        return new SingleValueAccum<T>(this.value);
    }

    @Override
    public ValueHolder<T> createHolder() {
        return new ObjectHolder();
    }
}

