/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import org.dflib.Extractor;
import org.dflib.Series;
import org.dflib.builder.ValueAccum;

public class SeriesAppender<S, T> {
    protected final Extractor<S, T> extractor;
    protected final ValueAccum<T> accum;

    public SeriesAppender(Extractor<S, T> extractor, int accumCapacity) {
        this.extractor = extractor;
        this.accum = extractor.createAccum(accumCapacity);
    }

    public SeriesAppender<S, T> append(S from) {
        this.extractor.extractAndStore(from, this.accum);
        return this;
    }

    public SeriesAppender<S, T> append(Iterable<S> from) {
        for (S s : from) {
            this.append(s);
        }
        return this;
    }

    public void replace(S from, int toPos) {
        this.extractor.extractAndStore(from, this.accum, toPos);
    }

    public int size() {
        return this.accum.size();
    }

    public Series<T> toSeries() {
        return this.accum.toSeries();
    }
}

