/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import org.dflib.Extractor;
import org.dflib.ValueMapper;
import org.dflib.builder.CompactObjectExtractor;
import org.dflib.builder.ObjectAccum;
import org.dflib.builder.ObjectHolder;
import org.dflib.builder.ValueAccum;
import org.dflib.builder.ValueHolder;
import org.dflib.builder.ValueStore;

public class ObjectExtractor<F, T>
implements Extractor<F, T> {
    private final ValueMapper<F, T> mapper;

    public ObjectExtractor(ValueMapper<F, T> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Extractor<F, T> compact() {
        return new CompactObjectExtractor<F, T>(this.mapper);
    }

    @Override
    public void extractAndStore(F from, ValueStore<T> to) {
        to.push(this.mapper.map(from));
    }

    @Override
    public void extractAndStore(F from, ValueStore<T> to, int toPos) {
        to.replace(toPos, this.mapper.map(from));
    }

    @Override
    public ValueAccum<T> createAccum(int capacity) {
        return new ObjectAccum(capacity);
    }

    @Override
    public ValueHolder<T> createHolder() {
        return new ObjectHolder();
    }
}

