/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import org.dflib.Extractor;
import org.dflib.FloatValueMapper;
import org.dflib.builder.FloatAccum;
import org.dflib.builder.FloatHolder;
import org.dflib.builder.ValueAccum;
import org.dflib.builder.ValueHolder;
import org.dflib.builder.ValueStore;

public class FloatExtractor<F>
implements Extractor<F, Float> {
    private final FloatValueMapper<F> mapper;

    public FloatExtractor(FloatValueMapper<F> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Extractor<F, Float> compact() {
        return this;
    }

    @Override
    public void extractAndStore(F from, ValueStore<Float> to) {
        to.pushFloat(this.mapper.map(from));
    }

    @Override
    public void extractAndStore(F from, ValueStore<Float> to, int toPos) {
        to.replaceFloat(toPos, this.mapper.map(from));
    }

    @Override
    public ValueAccum<Float> createAccum(int capacity) {
        return new FloatAccum(capacity);
    }

    @Override
    public ValueHolder<Float> createHolder() {
        return new FloatHolder();
    }
}

