/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import org.dflib.DoubleValueMapper;
import org.dflib.Extractor;
import org.dflib.builder.DoubleAccum;
import org.dflib.builder.DoubleHolder;
import org.dflib.builder.ValueAccum;
import org.dflib.builder.ValueHolder;
import org.dflib.builder.ValueStore;

public class DoubleExtractor<F>
implements Extractor<F, Double> {
    private final DoubleValueMapper<F> mapper;

    public DoubleExtractor(DoubleValueMapper<F> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Extractor<F, Double> compact() {
        return this;
    }

    @Override
    public void extractAndStore(F from, ValueStore<Double> to) {
        to.pushDouble(this.mapper.map(from));
    }

    @Override
    public void extractAndStore(F from, ValueStore<Double> to, int toPos) {
        to.replaceDouble(toPos, this.mapper.map(from));
    }

    @Override
    public ValueAccum<Double> createAccum(int capacity) {
        return new DoubleAccum(capacity);
    }

    @Override
    public ValueHolder<Double> createHolder() {
        return new DoubleHolder();
    }
}

