/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import java.util.Arrays;
import org.dflib.DoubleSeries;
import org.dflib.builder.ValueAccum;
import org.dflib.series.DoubleArraySeries;

public class DoubleAccum
implements ValueAccum<Double> {
    private double[] data;
    private int size = 0;

    public DoubleAccum() {
        this(10);
    }

    public DoubleAccum(int capacity) {
        this.data = new double[capacity];
    }

    public void fill(DoubleSeries values, int valuesOffset, int accumOffset, int len) {
        if (len <= 0) {
            return;
        }
        int pastFillEnd = accumOffset + len;
        if (this.data.length < pastFillEnd) {
            this.expand(pastFillEnd);
            this.size = pastFillEnd;
        } else if (this.size < pastFillEnd) {
            this.size = pastFillEnd;
        }
        values.copyToDouble(this.data, valuesOffset, accumOffset, len);
    }

    public void fill(int from, int to, double value) {
        if (to - from < 1) {
            return;
        }
        if (this.data.length <= to) {
            this.expand(to);
        }
        Arrays.fill(this.data, from, to, value);
        this.size += to - from;
    }

    @Override
    public void push(Double v) {
        this.pushDouble(v != null ? v : 0.0);
    }

    @Override
    public void pushDouble(double value) {
        if (this.size == this.data.length) {
            this.expand(this.data.length * 2);
        }
        this.data[this.size++] = value;
    }

    @Override
    public void replace(int pos, Double v) {
        this.replaceDouble(pos, v != null ? v : 0.0);
    }

    @Override
    public void replaceDouble(int pos, double value) {
        if (pos >= this.size) {
            this.size = pos + 1;
        }
        if (this.size >= this.data.length) {
            this.expand(Math.max(this.data.length * 2, this.size));
        }
        this.data[pos] = value;
    }

    public DoubleSeries toSeries() {
        double[] data = this.compactData();
        this.data = null;
        return new DoubleArraySeries(data);
    }

    @Override
    public int size() {
        return this.size;
    }

    private double[] compactData() {
        if (this.data.length == this.size) {
            return this.data;
        }
        double[] newData = new double[this.size];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        return newData;
    }

    private void expand(int newCapacity) {
        double[] newData = new double[newCapacity];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
    }
}

