/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.dflib.ColumnDataFrame;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.Series;
import org.dflib.builder.BaseDataFrameBuilder;
import org.dflib.series.ArraySeries;
import org.dflib.series.DoubleArraySeries;
import org.dflib.series.FloatArraySeries;
import org.dflib.series.IntArraySeries;
import org.dflib.series.LongArraySeries;

public class DataFrameFoldByRowBuilder
extends BaseDataFrameBuilder {
    public DataFrameFoldByRowBuilder(Index columnsIndex) {
        super(columnsIndex);
    }

    public DataFrame of(Object ... data) {
        int j;
        Geometry g = this.geometry(data.length);
        Object[][] columnarData = new Object[g.width][g.height];
        for (int i = 0; i < g.fullRowsHeight; ++i) {
            for (j = 0; j < g.width; ++j) {
                columnarData[j][i] = data[i * g.width + j];
            }
        }
        if (g.isLastRowPartial()) {
            int lastRowIndex = g.fullRowsHeight;
            for (j = 0; j < g.partialRowWidth; ++j) {
                columnarData[j][lastRowIndex] = data[lastRowIndex * g.width + j];
            }
        }
        Series[] series = new Series[g.width];
        for (int i = 0; i < g.width; ++i) {
            series[i] = new ArraySeries<Object>(columnarData[i]);
        }
        return new ColumnDataFrame(null, this.columnsIndex, series);
    }

    public <T> DataFrame ofIterable(Iterable<T> iterable) {
        return this.of(this.toCollection(iterable).toArray());
    }

    public <T> DataFrame ofStream(Stream<T> stream) {
        return this.of(stream.toArray());
    }

    public DataFrame ofFloats(float padWith, float ... data) {
        int j;
        Geometry g = this.geometry(data.length);
        float[][] columnarData = new float[g.width][g.height];
        for (int i = 0; i < g.fullRowsHeight; ++i) {
            for (j = 0; j < g.width; ++j) {
                columnarData[j][i] = data[i * g.width + j];
            }
        }
        if (g.isLastRowPartial()) {
            int lastRowIndex = g.fullRowsHeight;
            for (j = 0; j < g.partialRowWidth; ++j) {
                columnarData[j][lastRowIndex] = data[lastRowIndex * g.width + j];
            }
            for (j = g.partialRowWidth; j < g.width; ++j) {
                columnarData[j][lastRowIndex] = padWith;
            }
        }
        Series[] series = new Series[g.width];
        for (int i = 0; i < g.width; ++i) {
            series[i] = new FloatArraySeries(columnarData[i]);
        }
        return new ColumnDataFrame(null, this.columnsIndex, series);
    }

    public DataFrame ofDoubles(double padWith, double ... data) {
        int j;
        Geometry g = this.geometry(data.length);
        double[][] columnarData = new double[g.width][g.height];
        for (int i = 0; i < g.fullRowsHeight; ++i) {
            for (j = 0; j < g.width; ++j) {
                columnarData[j][i] = data[i * g.width + j];
            }
        }
        if (g.isLastRowPartial()) {
            int lastRowIndex = g.fullRowsHeight;
            for (j = 0; j < g.partialRowWidth; ++j) {
                columnarData[j][lastRowIndex] = data[lastRowIndex * g.width + j];
            }
            for (j = g.partialRowWidth; j < g.width; ++j) {
                columnarData[j][lastRowIndex] = padWith;
            }
        }
        Series[] series = new Series[g.width];
        for (int i = 0; i < g.width; ++i) {
            series[i] = new DoubleArraySeries(columnarData[i]);
        }
        return new ColumnDataFrame(null, this.columnsIndex, series);
    }

    public DataFrame ofStream(DoubleStream stream) {
        return this.ofStream(0.0, stream);
    }

    public DataFrame ofStream(double padWith, DoubleStream stream) {
        return this.ofDoubles(padWith, stream.toArray());
    }

    public DataFrame ofInts(int padWith, int ... data) {
        int j;
        Geometry g = this.geometry(data.length);
        int[][] columnarData = new int[g.width][g.height];
        for (int i = 0; i < g.fullRowsHeight; ++i) {
            for (j = 0; j < g.width; ++j) {
                columnarData[j][i] = data[i * g.width + j];
            }
        }
        if (g.isLastRowPartial()) {
            int lastRowIndex = g.fullRowsHeight;
            for (j = 0; j < g.partialRowWidth; ++j) {
                columnarData[j][lastRowIndex] = data[lastRowIndex * g.width + j];
            }
            for (j = g.partialRowWidth; j < g.width; ++j) {
                columnarData[j][lastRowIndex] = padWith;
            }
        }
        Series[] series = new Series[g.width];
        for (int i = 0; i < g.width; ++i) {
            series[i] = new IntArraySeries(columnarData[i]);
        }
        return new ColumnDataFrame(null, this.columnsIndex, series);
    }

    public DataFrame ofStream(IntStream stream) {
        return this.ofStream(0, stream);
    }

    public DataFrame ofStream(int padWith, IntStream stream) {
        return this.ofInts(padWith, stream.toArray());
    }

    public DataFrame ofLongs(long padWith, long ... data) {
        int j;
        Geometry g = this.geometry(data.length);
        long[][] columnarData = new long[g.width][g.height];
        for (int i = 0; i < g.fullRowsHeight; ++i) {
            for (j = 0; j < g.width; ++j) {
                columnarData[j][i] = data[i * g.width + j];
            }
        }
        if (g.isLastRowPartial()) {
            int lastRowIndex = g.fullRowsHeight;
            for (j = 0; j < g.partialRowWidth; ++j) {
                columnarData[j][lastRowIndex] = data[lastRowIndex * g.width + j];
            }
            for (j = g.partialRowWidth; j < g.width; ++j) {
                columnarData[j][lastRowIndex] = padWith;
            }
        }
        Series[] series = new Series[g.width];
        for (int i = 0; i < g.width; ++i) {
            series[i] = new LongArraySeries(columnarData[i]);
        }
        return new ColumnDataFrame(null, this.columnsIndex, series);
    }

    public DataFrame ofStream(LongStream stream) {
        return this.ofStream(0L, stream);
    }

    public DataFrame ofStream(long padWith, LongStream stream) {
        return this.ofLongs(padWith, stream.toArray());
    }

    protected Geometry geometry(int dataLength) {
        int w = this.columnsIndex.size();
        if (w == 0) {
            throw new IllegalArgumentException("Empty columns");
        }
        int lastRowWidth = dataLength % w;
        int completeRowsHeight = dataLength / w;
        int fullHeight = lastRowWidth > 0 ? completeRowsHeight + 1 : completeRowsHeight;
        return new Geometry(w, fullHeight, completeRowsHeight, lastRowWidth);
    }

    static class Geometry {
        final int width;
        final int height;
        final int fullRowsHeight;
        final int partialRowWidth;

        public Geometry(int width, int height, int fullRowsHeight, int partialRowWidth) {
            this.width = width;
            this.height = height;
            this.fullRowsHeight = fullRowsHeight;
            this.partialRowWidth = partialRowWidth;
        }

        public boolean isLastRowPartial() {
            return this.partialRowWidth > 0;
        }
    }
}

