/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import org.dflib.DataFrame;
import org.dflib.Extractor;
import org.dflib.Index;
import org.dflib.RowPredicate;
import org.dflib.builder.DataFrameAppender;
import org.dflib.builder.DefaultRowAccum;
import org.dflib.builder.FilteringRowAccum;
import org.dflib.builder.RowAccum;
import org.dflib.builder.SamplingRowAccum;
import org.dflib.builder.SeriesAppender;
import org.dflib.sample.Sampler;

public class DataFrameByRowBuilder<S, B extends DataFrameByRowBuilder<S, B>> {
    static final int DEFAULT_CAPACITY = 1000;
    private final Extractor<S, ?>[] columnsExtractors;
    private Index columnsIndex;
    private int capacity;
    protected int rowSampleSize;
    private Random rowsSampleRandom;
    private RowPredicate rowFilter;

    @SafeVarargs
    public DataFrameByRowBuilder(Extractor<S, ?> ... extractors) {
        this.columnsExtractors = Objects.requireNonNull(extractors);
    }

    public B columnNames(String ... columnNames) {
        return this.columnIndex(Index.of(columnNames));
    }

    public B columnIndex(Index columnsIndex) {
        if (columnsIndex.size() != this.columnsExtractors.length) {
            throw new IllegalArgumentException("Column index size must match the size of the extractors (" + this.columnsExtractors.length + "): " + columnsIndex.size());
        }
        this.columnsIndex = columnsIndex;
        return (B)this;
    }

    public B capacity(int capacity) {
        this.capacity = capacity;
        return (B)this;
    }

    public B selectRows(RowPredicate rowFilter) {
        this.rowFilter = rowFilter;
        return (B)this;
    }

    public B sampleRows(int size) {
        return this.sampleRows(size, Sampler.getDefaultRandom());
    }

    public B sampleRows(int size, Random random) {
        this.rowSampleSize = size;
        this.rowsSampleRandom = random;
        return (B)this;
    }

    public DataFrame ofIterable(Iterable<S> sources) {
        int autoCapacity = sources instanceof Collection ? ((Collection)sources).size() : -1;
        int capacity = this.guessCapacity(autoCapacity);
        return this.appender(capacity).append(sources).toDataFrame();
    }

    public DataFrameAppender<S> appender() {
        return this.appender(this.guessCapacity(-1));
    }

    protected DataFrameAppender<S> appender(int capacity) {
        RowAccum<S> rowAccum = this.rowAccum(capacity);
        return new DataFrameAppender<S>(rowAccum);
    }

    protected RowAccum<S> rowAccum(int capacity) {
        Index index = this.columnsIndex();
        SeriesAppender<S, ?>[] builders = this.builders(index, capacity);
        RowAccum<S> accum = new DefaultRowAccum<S>(index, builders);
        if (this.rowSampleSize > 0) {
            accum = new SamplingRowAccum<S>(accum, this.rowSampleSize, this.sampleRandom());
        }
        if (this.rowFilter != null) {
            accum = new FilteringRowAccum<S>(accum, this.rowFilter, index, this.columnsExtractors);
        }
        return accum;
    }

    protected Index columnsIndex() {
        if (this.columnsIndex != null) {
            return this.columnsIndex;
        }
        int w = this.width();
        String[] labels = new String[w];
        for (int i = 0; i < w; ++i) {
            labels[i] = Integer.toString(i);
        }
        return Index.of(labels);
    }

    protected int width() {
        return this.columnsExtractors.length;
    }

    protected SeriesAppender<S, ?>[] builders(Index columnsIndex, int capacity) {
        int w = columnsIndex.size();
        int cw = this.columnsExtractors.length;
        SeriesAppender[] builders = new SeriesAppender[w];
        if (cw != w) {
            throw new IllegalArgumentException("Mismatch between the number of extractors and index width - " + cw + " vs " + w);
        }
        for (int i = 0; i < w; ++i) {
            builders[i] = new SeriesAppender(this.columnsExtractors[i], capacity);
        }
        return builders;
    }

    protected Random sampleRandom() {
        return this.rowsSampleRandom != null ? this.rowsSampleRandom : Sampler.getDefaultRandom();
    }

    protected int guessCapacity(int guessedCapacity) {
        int defaultCapacity;
        int n = defaultCapacity = guessedCapacity > 0 ? guessedCapacity : 1000;
        if (this.capacity > 0) {
            return this.capacity;
        }
        if (this.rowSampleSize > 0) {
            return Math.min(this.rowSampleSize, defaultCapacity);
        }
        return defaultCapacity;
    }
}

