/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import java.util.HashMap;
import java.util.Map;
import org.dflib.Extractor;
import org.dflib.ValueMapper;
import org.dflib.builder.ObjectAccum;
import org.dflib.builder.ObjectHolder;
import org.dflib.builder.ValueAccum;
import org.dflib.builder.ValueCompactor;
import org.dflib.builder.ValueHolder;
import org.dflib.builder.ValueStore;

public class CompactObjectExtractor<F, T>
implements Extractor<F, T> {
    private final ValueMapper<F, T> mapper;
    private final Map<T, T> valueCache;

    public CompactObjectExtractor(ValueMapper<F, T> mapper) {
        this.mapper = mapper;
        this.valueCache = new HashMap<T, T>();
    }

    @Override
    public Extractor<F, T> compact() {
        return this;
    }

    @Override
    public void extractAndStore(F from, ValueStore<T> to) {
        to.push(ValueCompactor.get(this.valueCache, this.mapper.map(from)));
    }

    @Override
    public void extractAndStore(F from, ValueStore<T> to, int toPos) {
        to.replace(toPos, ValueCompactor.get(this.valueCache, this.mapper.map(from)));
    }

    @Override
    public ValueAccum<T> createAccum(int capacity) {
        return new ObjectAccum(capacity);
    }

    @Override
    public ValueHolder<T> createHolder() {
        return new ObjectHolder();
    }
}

