/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import org.dflib.BooleanSeries;
import org.dflib.series.BooleanBitsetSeries;
import org.dflib.series.FalseSeries;

public class BoolBuilder {
    private static final int INDEX_BIT_SHIFT = 6;

    private BoolBuilder() {
    }

    public static BooleanSeries buildSeries(BoolGenerator generator, int size) {
        if (size == 0) {
            return new BooleanBitsetSeries(new long[0], 0);
        }
        long[] data = BoolBuilder.fill(generator, size);
        return data.length == 0 ? new FalseSeries(size) : new BooleanBitsetSeries(data, size);
    }

    private static long[] fill(BoolGenerator generator, int size) {
        int i;
        for (i = 0; i < size && !generator.get(i); ++i) {
        }
        if (i == size) {
            return new long[0];
        }
        long[] data = new long[1 + (size - 1 >> 6)];
        long element = 0L;
        int idx = i >> 6;
        int end = Math.min(idx + 1 << 6, size);
        while (i < end) {
            if (generator.get(i)) {
                int n = idx;
                data[n] = data[n] | 1L << i;
            }
            ++i;
        }
        while (i < size) {
            for (int j = i; j < i + 64 && j < size; ++j) {
                if (!generator.get(j)) continue;
                element |= 1L << j;
            }
            data[i >> 6] = element;
            element = 0L;
            i += 64;
        }
        return data;
    }

    @FunctionalInterface
    public static interface BoolGenerator {
        public boolean get(int var1);
    }
}

