/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import org.dflib.BooleanSeries;
import org.dflib.Series;
import org.dflib.builder.ValueAccum;
import org.dflib.series.BooleanBitsetSeries;

public class BoolAccum
implements ValueAccum<Boolean> {
    private static final int DEFAULT_CAPACITY = 1;
    private static final int INDEX_BIT_SHIFT = 6;
    private long[] data;
    private int size;

    public BoolAccum() {
        this(1);
    }

    public BoolAccum(int capacity) {
        this.data = new long[BoolAccum.sizeInLongs(capacity)];
    }

    public void fill(BooleanSeries values, int fromOffset, int toOffset, int len) {
        if (len <= 0) {
            return;
        }
        int endPos = toOffset + len - 1;
        this.ensureCapacity(endPos >> 6);
        for (int i = 0; i < len; ++i) {
            int pos = toOffset + i;
            if (values.getBool(fromOffset + i)) {
                int n = pos >> 6;
                this.data[n] = this.data[n] | 1L << pos;
                continue;
            }
            int n = pos >> 6;
            this.data[n] = this.data[n] & (1L << pos ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (endPos >= this.size) {
            this.size = endPos + 1;
        }
    }

    public void fill(int from, int to, boolean value) {
        int toIdx = to - 1 >> 6;
        this.ensureCapacity(toIdx);
        for (int i = from; i < to; ++i) {
            if (value) {
                int n = i >> 6;
                this.data[n] = this.data[n] | 1L << i;
                continue;
            }
            int n = i >> 6;
            this.data[n] = this.data[n] & (1L << i ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (to > this.size) {
            this.size = to;
        }
    }

    @Override
    public void push(Boolean v) {
        this.pushBool(v != null ? v : false);
    }

    @Override
    public void pushBool(boolean v) {
        int idx = this.size >> 6;
        this.ensureCapacity(idx);
        if (v) {
            int n = idx;
            this.data[n] = this.data[n] | 1L << this.size;
        }
        ++this.size;
    }

    @Override
    public void replace(int pos, Boolean v) {
        this.replaceBool(pos, v != null ? v : false);
    }

    @Override
    public void replaceBool(int pos, boolean v) {
        int idx;
        if (pos >= this.size) {
            this.size = pos + 1;
            idx = this.size >> 6;
        } else {
            idx = pos >> 6;
        }
        this.ensureCapacity(idx);
        if (v) {
            int n = idx;
            this.data[n] = this.data[n] | 1L << pos;
        } else {
            int n = idx;
            this.data[n] = this.data[n] & (1L << pos ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public BooleanSeries toSeries() {
        if (this.size == 0) {
            return Series.ofBool(new boolean[0]);
        }
        long[] data = this.compactData();
        this.data = null;
        return new BooleanBitsetSeries(data, this.size);
    }

    private long[] compactData() {
        int realSize = BoolAccum.sizeInLongs(this.size);
        if (realSize == this.data.length) {
            return this.data;
        }
        long[] newData = new long[realSize];
        System.arraycopy(this.data, 0, newData, 0, realSize);
        return newData;
    }

    void ensureCapacity(int capacity) {
        int capacityToSet;
        if (capacity < this.data.length) {
            return;
        }
        for (capacityToSet = this.data.length * 2; capacity >= capacityToSet; capacityToSet *= 2) {
        }
        long[] newData = new long[capacityToSet];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
    }

    @Override
    public int size() {
        return this.size;
    }

    static int sizeInLongs(int capacity) {
        return (capacity - 1 >> 6) + 1;
    }
}

