/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.agg;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.dflib.Condition;
import org.dflib.DoubleSeries;
import org.dflib.Exp;
import org.dflib.FloatSeries;
import org.dflib.Series;
import org.dflib.Sorter;

public class Percentiles {
    private static final Condition notNullExp = Exp.$col(0).isNotNull();
    private static final Sorter asc = Exp.$col(0).asc();

    private static void checkIsPercentile(double quantile) {
        if (quantile < 0.0 || quantile > 1.0) {
            throw new IllegalArgumentException("Invalid quantile: " + quantile + ". Quantile is expected to be a percentile in the range of 0.0 .. 1.0");
        }
    }

    public static double ofRange(double quantile, int first, int lastExclusive) {
        Percentiles.checkIsPercentile(quantile);
        int len = lastExclusive - first;
        switch (len) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return first;
            }
        }
        double di = quantile * (double)(len - 1);
        int lower = (int)Math.floor(di);
        int upper = (int)Math.ceil(di);
        return lower == upper ? (double)(first + lower) : (double)first + di;
    }

    public static double ofArray(int[] vals, int start, int len, double quantile) {
        Percentiles.checkIsPercentile(quantile);
        switch (len) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return vals[0];
            }
        }
        int[] copy = new int[len];
        System.arraycopy(vals, start, copy, 0, len);
        Arrays.sort(copy);
        double di = quantile * (double)(len - 1);
        int lower = (int)Math.floor(di);
        int upper = (int)Math.ceil(di);
        return lower == upper ? (double)copy[lower] : (double)copy[lower] + (di - (double)lower) * (double)(copy[upper] - copy[lower]);
    }

    public static double ofArray(long[] vals, int start, int len, double quantile) {
        Percentiles.checkIsPercentile(quantile);
        switch (len) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return vals[0];
            }
        }
        long[] copy = new long[len];
        System.arraycopy(vals, start, copy, 0, len);
        Arrays.sort(copy);
        double di = quantile * (double)(len - 1);
        int lower = (int)Math.floor(di);
        int upper = (int)Math.ceil(di);
        return lower == upper ? (double)copy[lower] : (double)copy[lower] + (di - (double)lower) * (double)(copy[upper] - copy[lower]);
    }

    public static float ofArray(double quantile, int start, int len, float[] vals) {
        Percentiles.checkIsPercentile(quantile);
        switch (len) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return vals[0];
            }
        }
        float[] copy = new float[len];
        System.arraycopy(vals, start, copy, 0, len);
        Arrays.sort(copy);
        double di = quantile * (double)(len - 1);
        int lower = (int)Math.floor(di);
        int upper = (int)Math.ceil(di);
        return lower == upper ? copy[lower] : (float)((double)copy[lower] + (di - (double)lower) * (double)(copy[upper] - copy[lower]));
    }

    public static double ofArray(double[] vals, int start, int len, double quantile) {
        Percentiles.checkIsPercentile(quantile);
        switch (len) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return vals[0];
            }
        }
        double[] copy = new double[len];
        System.arraycopy(vals, start, copy, 0, len);
        Arrays.sort(copy);
        double di = quantile * (double)(len - 1);
        int lower = (int)Math.floor(di);
        int upper = (int)Math.ceil(di);
        return lower == upper ? copy[lower] : copy[lower] + (di - (double)lower) * (copy[upper] - copy[lower]);
    }

    public static double ofDoubles(Series<? extends Number> s, double quantile) {
        DoubleSeries ds = s instanceof DoubleSeries ? (DoubleSeries)s : s.select(notNullExp).compactDouble(Number::doubleValue);
        return ds.quantile(quantile);
    }

    public static float ofFloats(Series<? extends Number> s, double quantile) {
        FloatSeries ps = s instanceof FloatSeries ? (FloatSeries)s : s.select(notNullExp).compactFloat(Number::floatValue);
        return ps.quantile(quantile);
    }

    public static BigDecimal ofBigints(Series<BigInteger> s, double quantile) {
        Percentiles.checkIsPercentile(quantile);
        Series<BigInteger> noNulls = s.select(notNullExp);
        int len = noNulls.size();
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                return new BigDecimal(noNulls.get(0));
            }
        }
        Series<BigInteger> sorted = noNulls.sort(asc);
        double di = quantile * (double)(len - 1);
        int lower = (int)Math.floor(di);
        int upper = (int)Math.ceil(di);
        if (lower == upper) {
            return new BigDecimal(sorted.get(lower));
        }
        BigDecimal lbd = new BigDecimal(sorted.get(lower));
        BigDecimal ubd = new BigDecimal(sorted.get(upper));
        BigDecimal fraction = BigDecimal.valueOf(di - (double)lower);
        return lbd.add(ubd.subtract(lbd).multiply(fraction));
    }

    public static BigDecimal ofDecimals(Series<BigDecimal> s, double quantile) {
        Percentiles.checkIsPercentile(quantile);
        Series<BigDecimal> noNulls = s.select(notNullExp);
        int len = noNulls.size();
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                return noNulls.get(0);
            }
        }
        Series<BigDecimal> sorted = noNulls.sort(asc);
        double di = quantile * (double)(len - 1);
        int lower = (int)Math.floor(di);
        int upper = (int)Math.ceil(di);
        if (lower == upper) {
            return sorted.get(lower);
        }
        BigDecimal lbd = sorted.get(lower);
        BigDecimal ubd = sorted.get(upper);
        BigDecimal fraction = BigDecimal.valueOf(di - (double)lower);
        return lbd.add(ubd.subtract(lbd).multiply(fraction));
    }

    public static LocalDate ofDates(Series<LocalDate> s, double quantile) {
        Percentiles.checkIsPercentile(quantile);
        Series<LocalDate> noNulls = s.select(notNullExp);
        int len = noNulls.size();
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                return noNulls.get(0);
            }
        }
        Series<LocalDate> sorted = noNulls.sort(asc);
        double di = quantile * (double)(len - 1);
        int lower = (int)Math.floor(di);
        int upper = (int)Math.ceil(di);
        if (lower == upper) {
            return sorted.get(lower);
        }
        LocalDate d1 = sorted.get(lower);
        LocalDate d2 = sorted.get(upper);
        double fraction = di - (double)lower;
        return d1.plusDays(Math.round(fraction * (double)ChronoUnit.DAYS.between(d1, d2)));
    }

    public static LocalTime ofTimes(Series<LocalTime> s, double quantile) {
        Percentiles.checkIsPercentile(quantile);
        Series<LocalTime> noNulls = s.select(notNullExp);
        int len = noNulls.size();
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                return noNulls.get(0);
            }
        }
        Series<LocalTime> sorted = noNulls.sort(asc);
        double di = quantile * (double)(len - 1);
        int lower = (int)Math.floor(di);
        int upper = (int)Math.ceil(di);
        if (lower == upper) {
            return sorted.get(lower);
        }
        LocalTime d1 = sorted.get(lower);
        LocalTime d2 = sorted.get(upper);
        double fraction = di - (double)lower;
        return d1.plusNanos(Math.round(fraction * (double)ChronoUnit.NANOS.between(d1, d2)));
    }

    public static LocalDateTime ofDateTimes(Series<LocalDateTime> s, double quantile) {
        Percentiles.checkIsPercentile(quantile);
        Series<LocalDateTime> noNulls = s.select(notNullExp);
        int len = noNulls.size();
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                return noNulls.get(0);
            }
        }
        Series<LocalDateTime> sorted = noNulls.sort(asc);
        double di = quantile * (double)(len - 1);
        int lower = (int)Math.floor(di);
        int upper = (int)Math.ceil(di);
        if (lower == upper) {
            return sorted.get(lower);
        }
        LocalDateTime d1 = sorted.get(lower);
        LocalDateTime d2 = sorted.get(upper);
        double fraction = di - (double)lower;
        return d1.plusNanos(Math.round(fraction * (double)ChronoUnit.NANOS.between(d1, d2)));
    }
}

