/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.agg;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.dflib.DataFrame;
import org.dflib.Environment;
import org.dflib.Exp;
import org.dflib.GroupBy;
import org.dflib.Series;
import org.dflib.builder.ObjectAccum;

public class GroupByAggregator {
    public static Series<?>[] agg(GroupBy groupBy, Exp<?> ... aggregators) {
        int aggW = aggregators.length;
        int aggH = groupBy.size();
        Series[] aggColumns = new Series[aggW];
        Environment env = Environment.commonEnv();
        if (aggW <= 1 || groupBy.getSource().height() < env.parallelExecThreshold()) {
            for (int i = 0; i < aggW; ++i) {
                aggColumns[i] = GroupByAggregator.agg(groupBy, aggregators[i], aggH);
            }
        } else {
            int i;
            ExecutorService pool = env.threadPool();
            Future[] aggTasks = new Future[aggW];
            for (i = 0; i < aggW; ++i) {
                Exp<?> agg = aggregators[i];
                aggTasks[i] = pool.submit(() -> GroupByAggregator.agg(groupBy, agg, aggH));
            }
            for (i = 0; i < aggW; ++i) {
                try {
                    aggColumns[i] = (Series)aggTasks[i].get();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return aggColumns;
    }

    private static Series<?> agg(GroupBy groupBy, Exp<?> agg, int aggH) {
        ObjectAccum columnBuilder = new ObjectAccum(aggH);
        for (Object key : groupBy.getGroupKeys()) {
            DataFrame group = groupBy.getGroup(key);
            columnBuilder.push(agg.reduce(group));
        }
        return columnBuilder.toSeries();
    }
}

