/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.dflib.Condition;
import org.dflib.DecimalExp;
import org.dflib.Exp;
import org.dflib.NumExp;
import org.dflib.exp.agg.ComparableAggregators;
import org.dflib.exp.agg.StrReduceExp1;
import org.dflib.exp.map.MapCondition1;
import org.dflib.exp.map.MapCondition2;
import org.dflib.exp.map.MapExp1;
import org.dflib.exp.num.DecimalExp1;
import org.dflib.exp.num.DoubleExp1;
import org.dflib.exp.num.FloatExp1;
import org.dflib.exp.str.StrExp1;
import org.dflib.exp.str.StrSplitExp;

public interface StrExp
extends Exp<String> {
    @Override
    default public StrExp castAsStr() {
        return this;
    }

    @Override
    default public Condition castAsBool() {
        return MapCondition1.mapVal("castAsBool", this, Boolean::valueOf);
    }

    default public <E extends Enum<E>> Exp<E> castAsEnum(Class<E> type) {
        return MapExp1.mapVal("castAsEnum", type, this, s -> Enum.valueOf(type, s));
    }

    @Override
    default public NumExp<Integer> castAsInt() {
        return this.castAsDecimal().castAsInt();
    }

    @Override
    default public NumExp<Long> castAsLong() {
        return this.castAsDecimal().castAsLong();
    }

    @Override
    default public NumExp<Float> castAsFloat() {
        return FloatExp1.mapVal("castAsFloat", this, Float::parseFloat);
    }

    @Override
    default public NumExp<Double> castAsDouble() {
        return DoubleExp1.mapVal("castAsDouble", this, Double::parseDouble);
    }

    @Override
    default public DecimalExp castAsDecimal() {
        return DecimalExp1.mapVal("castAsDecimal", this, BigDecimal::new);
    }

    default public Condition matches(String regex) {
        Pattern p = Pattern.compile(regex);
        return MapCondition2.mapVal("matches", this, Exp.$val(regex), (s, r) -> p.matcher((CharSequence)s).matches());
    }

    default public Condition startsWith(String prefix) {
        return MapCondition2.mapVal("startsWith", this, Exp.$val(prefix), (s, p) -> s.startsWith(prefix));
    }

    default public Condition endsWith(String suffix) {
        return MapCondition2.mapVal("endsWith", this, Exp.$val(suffix), (s, p) -> s.endsWith(suffix));
    }

    default public Condition contains(String substring) {
        return MapCondition2.mapVal("contains", this, Exp.$val(substring), (s, p) -> s.contains(substring));
    }

    default public StrExp substr(int fromInclusive) {
        if (fromInclusive == 0) {
            return StrExp1.mapVal("substr", this, s -> s);
        }
        if (fromInclusive < 0) {
            int endOffset = -fromInclusive;
            return StrExp1.mapVal("substr", this, s -> s.length() <= endOffset ? "" : s.substring(s.length() - endOffset));
        }
        return StrExp1.mapVal("substr", this, s -> s.length() <= fromInclusive ? "" : s.substring(fromInclusive));
    }

    default public StrExp substr(int fromInclusive, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("'len' must be non-negative: " + len);
        }
        if (len == 0) {
            return StrExp1.mapVal("substr", this, s -> "");
        }
        if (fromInclusive < 0) {
            int endOffset = -fromInclusive;
            return StrExp1.mapVal("substr", this, s -> s.length() <= endOffset ? "" : s.substring(s.length() - endOffset, Math.min(s.length(), s.length() - endOffset + len)));
        }
        return StrExp1.mapVal("substr", this, s -> s.length() <= fromInclusive ? "" : s.substring(fromInclusive, Math.min(s.length(), fromInclusive + len)));
    }

    default public StrExp trim() {
        return StrExp1.mapVal("trim", this, s -> {
            String trimmed = s.trim();
            return trimmed.isEmpty() ? null : trimmed;
        });
    }

    default public Exp<String[]> split(char delimiter) {
        return this.split(delimiter, 0);
    }

    default public Exp<String[]> split(char delimiter, int limit) {
        return StrSplitExp.splitOnChar(this, delimiter, limit);
    }

    default public Exp<String[]> split(String regex) {
        return StrSplitExp.splitOnRegex(this, regex);
    }

    default public Exp<String[]> split(String regex, int limit) {
        return StrSplitExp.splitOnRegex(this, regex, limit);
    }

    default public StrExp min() {
        return this.min(null);
    }

    default public StrExp min(Condition filter) {
        return new StrReduceExp1<String>("min", this, s -> (String)ComparableAggregators.min(s), filter);
    }

    default public StrExp max() {
        return this.max(null);
    }

    default public StrExp max(Condition filter) {
        return new StrReduceExp1<String>("max", this, s -> (String)ComparableAggregators.max(s), filter);
    }
}

