/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import org.dflib.BoolValueMapper;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.DoubleSeries;
import org.dflib.DoubleValueMapper;
import org.dflib.Exp;
import org.dflib.Extractor;
import org.dflib.FloatSeries;
import org.dflib.FloatValueMapper;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.IntValueMapper;
import org.dflib.LongSeries;
import org.dflib.LongValueMapper;
import org.dflib.SeriesGroupBy;
import org.dflib.Sorter;
import org.dflib.ValueMapper;
import org.dflib.ValueToRowMapper;
import org.dflib.agg.SeriesAggregator;
import org.dflib.builder.BoolBuilder;
import org.dflib.builder.SeriesByElementBuilder;
import org.dflib.op.ReplaceOp;
import org.dflib.series.ArraySeries;
import org.dflib.series.ColumnMappedSeries;
import org.dflib.series.DoubleArraySeries;
import org.dflib.series.DoubleSingleValueSeries;
import org.dflib.series.EmptySeries;
import org.dflib.series.FalseSeries;
import org.dflib.series.FloatArraySeries;
import org.dflib.series.FloatSingleValueSeries;
import org.dflib.series.IntArraySeries;
import org.dflib.series.IntSingleValueSeries;
import org.dflib.series.LongArraySeries;
import org.dflib.series.LongSingleValueSeries;
import org.dflib.series.OffsetLagSeries;
import org.dflib.series.OffsetLeadSeries;
import org.dflib.series.SingleValueSeries;
import org.dflib.series.TrueSeries;
import org.dflib.sort.SeriesSorter;

public interface Series<T>
extends Iterable<T> {
    public static <S, T> SeriesByElementBuilder<S, T> byElement(Extractor<S, T> extractor) {
        return new SeriesByElementBuilder<S, T>(extractor);
    }

    @SafeVarargs
    public static <T> Series<T> of(T ... data) {
        return data != null && data.length > 0 ? new ArraySeries<T>(data) : new EmptySeries();
    }

    public static <T> Series<T> ofIterable(Iterable<T> data) {
        return Series.byElement(Extractor.$col()).guessCapacity(data).appender().append(data).toSeries();
    }

    public static BooleanSeries ofBool(boolean ... bools) {
        return BoolBuilder.buildSeries(i -> bools[i], bools.length);
    }

    public static IntSeries ofInt(int ... ints) {
        return new IntArraySeries(ints);
    }

    public static FloatSeries ofFloat(float ... floats) {
        return new FloatArraySeries(floats);
    }

    public static DoubleSeries ofDouble(double ... doubles) {
        return new DoubleArraySeries(doubles);
    }

    public static LongSeries ofLong(long ... longs) {
        return new LongArraySeries(longs);
    }

    public static <T> Series<T> ofVal(T value, int size) {
        if (value == null) {
            return new SingleValueSeries<Object>(null, size);
        }
        if (value instanceof Integer) {
            return new IntSingleValueSeries((Integer)value, size);
        }
        if (value instanceof Long) {
            return new LongSingleValueSeries((Long)value, size);
        }
        if (value instanceof Double) {
            return new DoubleSingleValueSeries((Double)value, size);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? new TrueSeries(size) : new FalseSeries(size);
        }
        if (value instanceof Float) {
            return new FloatSingleValueSeries(((Float)value).floatValue(), size);
        }
        return new SingleValueSeries<T>(value, size);
    }

    public Class<?> getNominalType();

    public Class<?> getInferredType();

    public int size();

    public T get(int var1);

    public void copyTo(Object[] var1, int var2, int var3, int var4);

    public int position(T var1);

    default public boolean contains(T value) {
        return this.position(value) >= 0;
    }

    default public <V> Series<V> map(Exp<V> mapper) {
        return mapper.eval(this);
    }

    default public Series<?> expand(Object ... values) {
        int rlen = values.length;
        if (rlen == 0) {
            return this;
        }
        int llen = this.size();
        Object[] expanded = new Object[llen + rlen];
        this.copyTo(expanded, 0, 0, llen);
        System.arraycopy(values, 0, expanded, llen, rlen);
        return Series.of(expanded);
    }

    default public Series<?> insert(int pos, Object ... values) {
        if (pos < 0) {
            throw new IllegalArgumentException("Negative insert position: " + pos);
        }
        int slen = this.size();
        if (pos > slen) {
            throw new IllegalArgumentException("Insert position past the end of the Series: " + pos + ", len: " + slen);
        }
        int ilen = values.length;
        if (ilen == 0) {
            return this;
        }
        Object[] expanded = new Object[slen + ilen];
        if (pos > 0) {
            this.copyTo(expanded, 0, 0, pos);
        }
        System.arraycopy(values, 0, expanded, pos, ilen);
        if (pos < slen) {
            this.copyTo(expanded, pos, pos + ilen, slen - pos);
        }
        return Series.of(expanded);
    }

    default public <V> Series<V> map(ValueMapper<T, V> mapper) {
        return new ColumnMappedSeries<T, V>(this, mapper);
    }

    default public BooleanSeries compactBool() {
        return this.compactBool(BoolValueMapper.of());
    }

    default public BooleanSeries compactBool(BoolValueMapper<? super T> mapper) {
        int len = this.size();
        return BoolBuilder.buildSeries(i -> mapper.map((T)this.get(i)), len);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    default public BooleanSeries mapAsBool(BoolValueMapper<? super T> mapper) {
        return this.compactBool(mapper);
    }

    default public IntSeries compactInt(int forNull) {
        return this.compactInt(IntValueMapper.of(forNull));
    }

    default public IntSeries compactInt(IntValueMapper<? super T> mapper) {
        int len = this.size();
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = mapper.map(this.get(i));
        }
        return new IntArraySeries(data);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    default public IntSeries mapAsInt(IntValueMapper<? super T> mapper) {
        return this.compactInt(mapper);
    }

    default public LongSeries compactLong(long forNull) {
        return this.compactLong(LongValueMapper.of(forNull));
    }

    default public LongSeries compactLong(LongValueMapper<? super T> mapper) {
        int len = this.size();
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = mapper.map(this.get(i));
        }
        return new LongArraySeries(data);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    default public LongSeries mapAsLong(LongValueMapper<? super T> mapper) {
        return this.compactLong(mapper);
    }

    default public FloatSeries compactFloat(float forNull) {
        return this.compactFloat(FloatValueMapper.of(forNull));
    }

    default public FloatSeries compactFloat(FloatValueMapper<? super T> mapper) {
        int len = this.size();
        float[] data = new float[len];
        for (int i = 0; i < len; ++i) {
            data[i] = mapper.map(this.get(i));
        }
        return new FloatArraySeries(data);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    default public FloatSeries mapAsFloat(FloatValueMapper<? super T> mapper) {
        return this.compactFloat(mapper);
    }

    default public DoubleSeries compactDouble(double forNull) {
        return this.compactDouble(DoubleValueMapper.of(forNull));
    }

    default public DoubleSeries compactDouble(DoubleValueMapper<? super T> mapper) {
        int len = this.size();
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = mapper.map(this.get(i));
        }
        return new DoubleArraySeries(data);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    default public DoubleSeries mapAsDouble(DoubleValueMapper<? super T> mapper) {
        return this.compactDouble(mapper);
    }

    default public <S> Series<S> unsafeCastAs(Class<S> type) {
        return this;
    }

    public <S> Series<S> castAs(Class<S> var1) throws ClassCastException;

    default public BooleanSeries castAsBool() throws ClassCastException {
        throw new ClassCastException("Can't cast to BooleanSeries");
    }

    default public FloatSeries castAsFloat() throws ClassCastException {
        throw new ClassCastException("Can't cast to FloatSeries");
    }

    default public DoubleSeries castAsDouble() throws ClassCastException {
        throw new ClassCastException("Can't cast to DoubleSeries");
    }

    default public IntSeries castAsInt() throws ClassCastException {
        throw new ClassCastException("Can't cast to IntSeries");
    }

    default public LongSeries castAsLong() throws ClassCastException {
        throw new ClassCastException("Can't cast to LongSeries");
    }

    public DataFrame map(Index var1, ValueToRowMapper<T> var2);

    public Series<T> selectRange(int var1, int var2);

    public Series<T> materialize();

    public Series<T> fillNulls(T var1);

    public Series<T> fillNullsFromSeries(Series<? extends T> var1);

    public Series<T> fillNullsBackwards();

    public Series<T> fillNullsForward();

    public Series<T> concat(Series<? extends T> ... var1);

    public Series<T> diff(Series<? extends T> var1);

    public Series<T> intersect(Series<? extends T> var1);

    public Series<T> head(int var1);

    public Series<T> tail(int var1);

    public Series<T> select(Condition var1);

    default public Series<T> select(int ... positions) {
        return this.select(Series.ofInt(positions));
    }

    public Series<T> select(IntSeries var1);

    public Series<T> select(Predicate<T> var1);

    public Series<T> select(BooleanSeries var1);

    public IntSeries index(Predicate<T> var1);

    public Series<T> sort(Sorter ... var1);

    public Series<T> sort(Comparator<? super T> var1);

    default public IntSeries sortIndex(Comparator<? super T> comparator) {
        return new SeriesSorter<T>(this).sortIndex(comparator);
    }

    default public BooleanSeries eq(Series<?> s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> Objects.equals(this.get(i), s.get(i)), len);
    }

    default public BooleanSeries ne(Series<?> s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> !Objects.equals(this.get(i), s.get(i)), len);
    }

    public BooleanSeries isNull();

    public BooleanSeries isNotNull();

    public BooleanSeries in(Object ... var1);

    public BooleanSeries notIn(Object ... var1);

    default public BooleanSeries locate(Predicate<T> predicate) {
        return BoolBuilder.buildSeries(i -> predicate.test(this.get(i)), this.size());
    }

    default public Series<T> replace(int index, T with) {
        return ReplaceOp.replace(this, index, with);
    }

    public Series<T> replace(IntSeries var1, Series<T> var2);

    public Series<T> replace(BooleanSeries var1, T var2);

    public Series<T> replace(Map<T, T> var1);

    public Series<T> replaceExcept(BooleanSeries var1, T var2);

    public Series<T> unique();

    public DataFrame valueCounts();

    public SeriesGroupBy<T> group();

    public SeriesGroupBy<T> group(ValueMapper<T, ?> var1);

    @Deprecated(since="2.0.0", forRemoval=true)
    default public <R> Series<R> agg(Exp<R> aggregator) {
        return Series.ofVal(aggregator.reduce(this), 1);
    }

    default public <R> R reduce(Exp<R> reducer) {
        return reducer.reduce(this);
    }

    default public DataFrame aggMultiple(Exp<?> ... aggregators) {
        return SeriesAggregator.aggAsDataFrame(this, aggregators);
    }

    default public T first() {
        return this.size() > 0 ? (T)this.get(0) : null;
    }

    default public T last() {
        int size = this.size();
        return size > 0 ? (T)this.get(size - 1) : null;
    }

    default public String concat(String separator) {
        return this.reduce(Exp.$col("").vConcat(separator));
    }

    default public String concat(String separator, String prefix, String suffix) {
        return this.reduce(Exp.$col("").vConcat(separator, prefix, suffix));
    }

    public Series<T> sample(int var1);

    public Series<T> sample(int var1, Random var2);

    default public T reduce(T identity, BinaryOperator<T> accumulator) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(accumulator);
        int len = this.size();
        Object result = identity;
        for (int i = 0; i < len; ++i) {
            result = accumulator.apply(result, this.get(i));
        }
        return result;
    }

    default public Series<T> shift(int offset) {
        return this.shift(offset, null);
    }

    default public Series<T> shift(int offset, T filler) {
        if (offset > 0) {
            return new OffsetLeadSeries<T>(this, offset, filler);
        }
        if (offset < 0) {
            return new OffsetLagSeries<T>(this, offset, filler);
        }
        return this;
    }

    default public <V> Series<V> eval(Exp<V> exp) {
        return exp.eval(this);
    }

    @Override
    default public Iterator<T> iterator() {
        return new Iterator<T>(){
            final int len;
            int i;
            {
                this.len = Series.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.i < this.len;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Past the end of the iterator: " + this.i);
                }
                return Series.this.get(this.i++);
            }
        };
    }

    default public List<T> toList() {
        int len = this.size();
        Object[] copy = new Object[len];
        this.copyTo(copy, 0, 0, len);
        return Arrays.asList(copy);
    }

    default public Set<T> toSet() {
        int len = this.size();
        int capacity = len < 1000 ? (int)(1.0 + (double)len / 0.75) : 1300;
        LinkedHashSet<T> set = new LinkedHashSet<T>(capacity);
        for (int i = 0; i < len; ++i) {
            set.add(this.get(i));
        }
        return set;
    }

    default public T[] toArray(T[] a) {
        int len = this.size();
        Object[] copy = a.length < len ? (Object[])Array.newInstance(a.getClass().getComponentType(), len) : a;
        this.copyTo(copy, 0, 0, len);
        return copy;
    }
}

