/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.dflib.BoolValueMapper;

public final class Predicates {
    public static Predicate<Object> isTrue() {
        return o -> {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            String s = o != null ? o.toString() : null;
            return Boolean.parseBoolean(s);
        };
    }

    public static BoolValueMapper<String> isTrueString() {
        return s -> Boolean.parseBoolean(s);
    }

    public static <T> Predicate<T> isIn(T ... values) {
        if (values.length == 0) {
            return v -> false;
        }
        if (values.length == 1) {
            return v -> Objects.equals(values[0], v);
        }
        HashSet<T> set = new HashSet<T>((int)((double)values.length / 0.75) + 1);
        for (T v2 : values) {
            set.add(v2);
        }
        return set::contains;
    }

    public static <T> Predicate<T> isIn(Iterable<? extends T> values) {
        HashSet<T> set;
        if (values instanceof Set) {
            set = (HashSet<T>)values;
        } else {
            set = new HashSet<T>();
            for (T v2 : values) {
                set.add(v2);
            }
        }
        if (set.size() == 0) {
            return v -> false;
        }
        if (set.size() == 1) {
            Object v1 = set.iterator().next();
            return v -> Objects.equals(v1, v);
        }
        return set::contains;
    }

    private Predicates() {
    }
}

