/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.dflib.Condition;
import org.dflib.DateExp;
import org.dflib.DateTimeExp;
import org.dflib.Exp;
import org.dflib.NumExp;
import org.dflib.TimeExp;
import org.dflib.exp.datetime.DateExp1;
import org.dflib.exp.datetime.DateTimeExp1;
import org.dflib.exp.datetime.OffsetDateTimeExp2;
import org.dflib.exp.datetime.TimeExp1;
import org.dflib.exp.map.MapCondition2;
import org.dflib.exp.map.MapCondition3;
import org.dflib.exp.map.MapExp1;
import org.dflib.exp.num.IntExp1;

public interface OffsetDateTimeExp
extends Exp<OffsetDateTime> {
    default public NumExp<Integer> year() {
        return IntExp1.mapVal("year", this, OffsetDateTime::getYear);
    }

    default public NumExp<Integer> month() {
        return IntExp1.mapVal("month", this, OffsetDateTime::getMonthValue);
    }

    default public NumExp<Integer> day() {
        return IntExp1.mapVal("year", this, OffsetDateTime::getDayOfMonth);
    }

    default public NumExp<Integer> hour() {
        return IntExp1.mapVal("hour", this, OffsetDateTime::getHour);
    }

    default public NumExp<Integer> minute() {
        return IntExp1.mapVal("minute", this, OffsetDateTime::getMinute);
    }

    default public NumExp<Integer> second() {
        return IntExp1.mapVal("second", this, OffsetDateTime::getSecond);
    }

    default public NumExp<Integer> millisecond() {
        return IntExp1.mapVal("millisecond", this, lt -> lt.get(ChronoField.MILLI_OF_SECOND));
    }

    default public Exp<ZoneOffset> offset() {
        return MapExp1.mapVal("offset", ZoneOffset.class, this, OffsetDateTime::getOffset);
    }

    default public Condition lt(Exp<OffsetDateTime> exp) {
        return MapCondition2.mapVal("<", this, exp.castAsOffsetDateTime(), (d1, d2) -> d1.compareTo((OffsetDateTime)d2) < 0);
    }

    default public Condition lt(OffsetDateTime val) {
        return this.lt(Exp.$offsetDateTimeVal(val));
    }

    default public Condition lt(String val) {
        return this.lt(OffsetDateTime.parse(val));
    }

    default public Condition le(Exp<OffsetDateTime> exp) {
        return MapCondition2.mapVal("<=", this, exp.castAsOffsetDateTime(), (d1, d2) -> d1.compareTo((OffsetDateTime)d2) <= 0);
    }

    default public Condition le(OffsetDateTime val) {
        return this.le(Exp.$offsetDateTimeVal(val));
    }

    default public Condition le(String val) {
        return this.le(OffsetDateTime.parse(val));
    }

    default public Condition gt(Exp<OffsetDateTime> exp) {
        return MapCondition2.mapVal(">", this, exp.castAsOffsetDateTime(), (d1, d2) -> d1.compareTo((OffsetDateTime)d2) > 0);
    }

    default public Condition gt(OffsetDateTime val) {
        return this.gt(Exp.$offsetDateTimeVal(val));
    }

    default public Condition gt(String val) {
        return this.gt(OffsetDateTime.parse(val));
    }

    default public Condition ge(Exp<OffsetDateTime> exp) {
        return MapCondition2.mapVal(">=", this, exp.castAsOffsetDateTime(), (d1, d2) -> d1.compareTo((OffsetDateTime)d2) >= 0);
    }

    default public Condition ge(OffsetDateTime val) {
        return this.ge(Exp.$offsetDateTimeVal(val));
    }

    default public Condition ge(String val) {
        return this.ge(OffsetDateTime.parse(val));
    }

    default public Condition between(Exp<OffsetDateTime> from, Exp<OffsetDateTime> to) {
        return MapCondition3.mapVal("between", "and", this, from.castAsOffsetDateTime(), to.castAsOffsetDateTime(), (d1, d2, d3) -> d1.compareTo((OffsetDateTime)d2) >= 0 && d1.compareTo((OffsetDateTime)d3) <= 0);
    }

    default public Condition between(OffsetDateTime from, OffsetDateTime to) {
        return this.between(Exp.$val(from), Exp.$val(to));
    }

    default public Condition between(String from, String to) {
        return this.between(OffsetDateTime.parse(from), OffsetDateTime.parse(to));
    }

    default public Condition eq(String val) {
        return Exp.super.eq(val == null ? null : OffsetDateTime.parse(val));
    }

    default public Condition ne(String val) {
        return Exp.super.ne(val == null ? null : OffsetDateTime.parse(val));
    }

    @Override
    default public OffsetDateTimeExp castAsOffsetDateTime(String format) {
        return this;
    }

    @Override
    default public OffsetDateTimeExp castAsOffsetDateTime(DateTimeFormatter formatter) {
        return this;
    }

    @Override
    default public OffsetDateTimeExp castAsOffsetDateTime() {
        return this;
    }

    @Override
    default public DateTimeExp castAsDateTime() {
        return DateTimeExp1.mapVal("dateTime", this, OffsetDateTime::toLocalDateTime);
    }

    @Override
    default public DateExp castAsDate() {
        return DateExp1.mapVal("date", this, OffsetDateTime::toLocalDate);
    }

    @Override
    default public TimeExp castAsTime() {
        return TimeExp1.mapVal("time", this, OffsetDateTime::toLocalTime);
    }

    default public OffsetDateTimeExp plusHours(int hours) {
        return OffsetDateTimeExp2.mapVal("plusHours", this, Exp.$val(hours), (lt, hrs) -> lt.plusHours(hours));
    }

    default public OffsetDateTimeExp plusMinutes(int minutes) {
        return OffsetDateTimeExp2.mapVal("plusMinutes", this, Exp.$val(minutes), (lt, m) -> lt.plusMinutes(minutes));
    }

    default public OffsetDateTimeExp plusSeconds(int seconds) {
        return OffsetDateTimeExp2.mapVal("plusSeconds", this, Exp.$val(seconds), (lt, s) -> lt.plusSeconds(seconds));
    }

    default public OffsetDateTimeExp plusMilliseconds(int ms) {
        return OffsetDateTimeExp2.mapVal("plusMilliseconds", this, Exp.$val(ms), (lt, m) -> lt.plus(ms, ChronoUnit.MILLIS));
    }

    default public OffsetDateTimeExp plusNanos(int nanos) {
        return OffsetDateTimeExp2.mapVal("plusNanos", this, Exp.$val(nanos), (lt, n) -> lt.plusNanos(nanos));
    }

    default public OffsetDateTimeExp plusDays(int days) {
        return OffsetDateTimeExp2.mapVal("plusDays", this, Exp.$val(days), (ld, d) -> ld.plusDays(days));
    }

    default public OffsetDateTimeExp plusWeeks(int weeks) {
        return OffsetDateTimeExp2.mapVal("plusWeeks", this, Exp.$val(weeks), (ld, w) -> ld.plusWeeks(w.intValue()));
    }

    default public OffsetDateTimeExp plusMonths(int months) {
        return OffsetDateTimeExp2.mapVal("plusMonths", this, Exp.$val(months), (ld, m) -> ld.plusMonths(m.intValue()));
    }

    default public OffsetDateTimeExp plusYears(int years) {
        return OffsetDateTimeExp2.mapVal("plusYears", this, Exp.$val(years), (ld, y) -> ld.plusYears(y.intValue()));
    }
}

