/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.math.BigInteger;
import java.util.Objects;
import org.dflib.Condition;
import org.dflib.DecimalExp;
import org.dflib.Exp;
import org.dflib.exp.bool.ConditionFactory;
import org.dflib.exp.num.NumAsExp;
import org.dflib.exp.num.NumericExpFactory;

public interface NumExp<N extends Number>
extends Exp<N> {
    @Override
    default public NumExp<N> as(String name) {
        Objects.requireNonNull(name, "Null 'name'");
        return new NumAsExp(name, this);
    }

    default public NumExp<?> add(Exp<? extends Number> exp) {
        return NumericExpFactory.factory(this, exp).add(this, exp);
    }

    default public NumExp<?> add(Number val) {
        Exp<Number> ve = Exp.$val(val);
        return NumericExpFactory.factory(this, ve).add(this, ve);
    }

    default public NumExp<?> sub(Exp<? extends Number> exp) {
        return NumericExpFactory.factory(this, exp).sub(this, exp);
    }

    default public NumExp<?> sub(Number val) {
        Exp<Number> ve = Exp.$val(val);
        return NumericExpFactory.factory(this, ve).sub(this, ve);
    }

    default public NumExp<?> mul(Exp<? extends Number> exp) {
        return NumericExpFactory.factory(this, exp).mul(this, exp);
    }

    default public NumExp<?> mul(Number val) {
        Exp<Number> ve = Exp.$val(val);
        return NumericExpFactory.factory(this, ve).mul(this, ve);
    }

    default public NumExp<?> div(Exp<? extends Number> exp) {
        return NumericExpFactory.factory(this, exp).div(this, exp);
    }

    default public NumExp<?> div(Number val) {
        Exp<Number> ve = Exp.$val(val);
        return NumericExpFactory.factory(this, ve).div(this, ve);
    }

    default public NumExp<?> mod(Exp<? extends Number> exp) {
        return NumericExpFactory.factory(this, exp).mod(this, exp);
    }

    default public NumExp<?> mod(Number val) {
        Exp<Number> ve = Exp.$val(val);
        return NumericExpFactory.factory(this, ve).mod(this, ve);
    }

    default public NumExp<N> abs() {
        return NumericExpFactory.factory(this).abs(this);
    }

    @Override
    default public NumExp<Integer> castAsInt() {
        return NumericExpFactory.factory(this).castAsInt(this);
    }

    @Override
    default public NumExp<Long> castAsLong() {
        return NumericExpFactory.factory(this).castAsLong(this);
    }

    @Override
    default public NumExp<Double> castAsDouble() {
        return NumericExpFactory.factory(this).castAsDouble(this);
    }

    @Override
    default public NumExp<Float> castAsFloat() {
        return NumericExpFactory.factory(this).castAsFloat(this);
    }

    @Override
    default public NumExp<BigInteger> castAsBigint() {
        return NumericExpFactory.factory(this).castAsBigint(this);
    }

    @Override
    default public DecimalExp castAsDecimal() {
        return NumericExpFactory.factory(this).castAsDecimal(this);
    }

    default public <E extends Enum<E>> Exp<E> castAsEnum(Class<E> type) {
        return NumericExpFactory.factory(this).castAsEnum(this, type);
    }

    @Override
    default public Condition eq(Exp<?> exp) {
        return Number.class.isAssignableFrom(exp.getType()) ? NumericExpFactory.factory(this, exp).eq(this, exp) : Exp.super.eq(exp);
    }

    @Override
    default public Condition eq(Object value) {
        return value instanceof Number ? this.eq(Exp.$val(value)) : Exp.super.eq(value);
    }

    @Override
    default public Condition ne(Exp<?> exp) {
        return Number.class.isAssignableFrom(exp.getType()) ? NumericExpFactory.factory(this, exp).ne(this, exp) : Exp.super.ne(exp);
    }

    @Override
    default public Condition ne(Object value) {
        return value instanceof Number ? this.ne(Exp.$val(value)) : Exp.super.ne(value);
    }

    default public Condition lt(Exp<? extends Number> exp) {
        return NumericExpFactory.factory(this, exp).lt(this, exp);
    }

    default public Condition lt(Number val) {
        Exp<Number> ve = Exp.$val(val);
        return NumericExpFactory.factory(this, ve).lt(this, ve);
    }

    default public Condition le(Exp<? extends Number> exp) {
        return NumericExpFactory.factory(this, exp).le(this, exp);
    }

    default public Condition le(Number val) {
        Exp<Number> ve = Exp.$val(val);
        return NumericExpFactory.factory(this, ve).le(this, ve);
    }

    default public Condition gt(Exp<? extends Number> exp) {
        return NumericExpFactory.factory(this, exp).gt(this, exp);
    }

    default public Condition gt(Number val) {
        Exp<Number> ve = Exp.$val(val);
        return NumericExpFactory.factory(this, ve).gt(this, ve);
    }

    default public Condition ge(Exp<? extends Number> exp) {
        return NumericExpFactory.factory(this, exp).ge(this, exp);
    }

    default public Condition ge(Number val) {
        Exp<Number> ve = Exp.$val(val);
        return NumericExpFactory.factory(this, ve).ge(this, ve);
    }

    default public Condition between(Exp<? extends Number> from, Exp<? extends Number> to) {
        return NumericExpFactory.factory(this.getType(), from.getType(), to.getType()).between(this, from, to);
    }

    default public Condition between(Number from, Number to) {
        return this.between(Exp.$val(from), Exp.$val(to));
    }

    default public NumExp<?> cumSum() {
        return NumericExpFactory.factory(this).cumSum(this);
    }

    default public NumExp<?> sum() {
        return this.sum(null);
    }

    default public NumExp<?> sum(Condition filter) {
        return NumericExpFactory.factory(this).sum(this, filter);
    }

    default public NumExp<?> min() {
        return this.min(null);
    }

    default public NumExp<?> min(Condition filter) {
        return NumericExpFactory.factory(this).min(this, filter);
    }

    default public NumExp<?> max() {
        return this.max(null);
    }

    default public NumExp<?> max(Condition filter) {
        return NumericExpFactory.factory(this).max(this, filter);
    }

    default public NumExp<?> avg() {
        return this.avg(null);
    }

    default public NumExp<?> avg(Condition filter) {
        return NumericExpFactory.factory(this).avg(this, filter);
    }

    default public NumExp<?> median() {
        return this.median(null);
    }

    default public NumExp<?> median(Condition filter) {
        return NumericExpFactory.factory(this).median(this, null);
    }

    default public NumExp<?> quantile(double q) {
        return this.quantile(q, null);
    }

    default public NumExp<?> quantile(double q, Condition filter) {
        return NumericExpFactory.factory(this).quantile(this, q, null);
    }

    default public NumExp<?> round() {
        return NumericExpFactory.factory(this).round(this);
    }

    @Override
    default public Condition castAsBool() {
        return ConditionFactory.castAsBool(this);
    }
}

